#
#  JSON     cf http://json.org/  (JavaScript Object Notation)
#  ssed     cf http://sed.sf.net/grabbag/ssed/  (Stream EDitor, gsed=GNU-sed, ssed=super-sed)
#  sed,tee  cf http://unxutils.sf.net/  or  http://gnuwin32.sf.net/
#  c2x-cmd  cf http://www.goedeke.net/c2x_cmd.html  (CSV2XML-Converter, v1.8.0+)
#  bzip2    cf http://bzip.org/  (De-/Compressor)
#  msxsl    cf http://msdn.microsoft.com/xml/  (Microsoft XSLT Processor/Interface)
#  nmake    (Microsoft Program Maintenance Utility v7.10.3077, req. msvcr71.dll)
#  nmake32  (IBM OS/2 Enhanced Program Maintenance Utility v5.00.003, 2000-10-20)
#           cf http://www.os2site.com/sw/dev/util/
#
#  nmake.exe -r -d -f Nobil-MAKE.mk MAKE="nmake -$(MAKEFLAGS)" [targets]
#            -r                     redef canceled predefined
#
#  nmake    vs    gmake
#  $(@B)          $(basename $@)
#  $(*F)          $(*F)  if known .SUFFIXES
#  -r             -R  but $(MAKE) remains+includes $(MAKEFLAGS)  ?
#  !directive     directive
#  !ERROR ...     $(error ...)
#  !MESSAGE ...   $(warning ...) or $(info ...)
#  <<infile       noop: no inline file(s)
#  <<NOKEEP       noop: no inline file(s) end-tag
#
#  ################################################################################

!ifndef  MAKE
!message MAKE-Macro not defined (due to -R Option ?)
MAKE   = nmake -$(MAKEFLAGS)
!message MAKE-Macro set default $(MAKE)
!endif

xmlNTT = Nobleza-TT.xml
xmlNob = Nobiliario.xml

xslNTT = Nobleza-TT.xsl
xslNob = Nobil-TEXT.xsl

sedNTT = Nobleza-TT.sed
sedNob = Nobiliario.sed
txtNob = Nobiliario.txt
xhtNob = Nobiliario.xht

!ifndef  xmlSrc
xmlSrc = $(xmlNTT)
!endif

JSONjs = Nobil-JSON.js
JSONnn = JSON2

.SUFFIXES :
.SUFFIXES : .noSED .GSED .SSED .unBZ2 .SPLIT .MERGE

#
#
#

all :: ; @echo [making update/bunzip test]
	-$(MAKE) -f <<Nobil-TEMP.mk
.SUFFIXES :
.SUFFIXES : .xml .bz2
$(xmlSrc) : $(xmlSrc).bz2 ; @echo [bunzip $(xmlSrc).bz2]
	bzip2 -dfkvv $(xmlSrc).bz2
<<NOKEEP

all :: $(JSONjs).gz $(txtNob).htm

#
#  ################################################################################
#

$(JSONjs)      : $(xmlNob).bz2 $(xslNob) ; @echo [making $@]
	bzip2 -dcvv  $(xmlNob).bz2 | msxsl - $(xslNob) -xw -t -o $@ NN=$(JSONnn) JS=Nobiliario

$(txtNob)      : $(xmlNob).bz2 $(xslNob) ; @echo [making $@]
	bzip2 -dcvv  $(xmlNob).bz2 | msxsl - $(xslNob) -xw -t -o $@ NN=TEXT
	gzip  -9fkNv $@

$(txtNob).htm  : $(txtNob) $(xhtNob).sed $(xhtNob).js $(xhtNob).json ; @echo [making $@]
	ssed  -f $(xhtNob).sed $(txtNob) > $@
	gzip  -9fkNv $@

$(xhtNob).json : $(JSONjs) $(xhtNob).jsed ; @echo [making $@]
	ssed -f $(xhtNob).jsed $(JSONjs) > $@

$(xmlSrc).bz2  : $(xmlSrc) ; @echo [making $@]
	bzip2 -9fkvv $(xmlSrc)

$(JSONjs).gz   : $(JSONjs) ; @echo [making $@]
	gzip  -9fkNv $(JSONjs)

#
#  Req : Request for making if xmlSrc = Nobleza-TT.xml | Nobiliario.xml
#

!if "$(xmlSrc)" == "$(xmlNob)"
xmlReq = nul
!else
xmlReq = $(xmlNob)
!endif

$(xmlReq)      : $(xmlNTT) $(xmlNTT).bz2 $(xslNTT) $(sedNob) ; @echo [making $@]
	msxsl $(xmlNTT) $(xslNTT) -xw -t NN=mergeTT | ssed -f $(sedNob) > $@

$(xmlReq).bz2  : $(xmlReq) ; @echo [making $@]
	bzip2 -9fkvv $(xmlReq)

#
#  CSV
#

txtCSV = Nobiliario.csv
cfgC2X = Nobiliario.c2x

$(txtCSV)      : $(xmlNob).bz2 $(xslNob) ; @echo [making $@]
	bzip2 -dcvv  $(xmlNob).bz2 | msxsl - $(xslNob) -xw -t -o $@ NN=CSV

$(txtCSV).bz2  : $(txtCSV) ; @echo [making $@]
	bzip2 -9fkvv $(txtCSV)

$(txtCSV).xml  : $(txtCSV) $(cfgC2X) ; @echo [making $@]
	c2x-cmd -cfg:$(cfgC2X)

#
#  ################################################################################
#
#  pseudotargets : last suffix stripped leaves real & only target w/o prerequisites
#

$(xmlSrc).unBZ2 : ; @echo [bunzip $(*F).bz2]
	bzip2 -dfkvv $(*F).bz2

$(xmlReq).unBZ2 : ; @echo [bunzip $(*F).bz2]
	bzip2 -dfkvv $(*F).bz2

#
#  EOF makefile
#

#
#  ################################################################################
#
#  XSLT-processors' usage for target "Nobil-JSON.js"
#

#
#  http://msdn.microsoft.com/xml/
#  msxsl -xw -t -o Nobil-JSON.js Nobiliario.xml Nobil-TEXT.xsl NN=JSON2
#
#  http://www.xmllab.net/
#  nxslt -xw -t -o Nobil-JSON.js Nobiliario.xml Nobil-TEXT.xsl NN=JSON2
#
#  http://www.gingerall.org/  +  http://libexpat.org/
#  sabcmd -m Nobil-TEXT.xsl Nobiliario.xml Nobil-JSON.js $NN=JSON2
#
#  http://saxon.sf.net/
#  saxon -t -o Nobil-JSON.js Nobiliario.xml Nobil-TEXT.xsl NN=JSON2
#
#  http://xmlsoft.org/  +  http://zlatkovic.com/libxml.en.html
#  xsltproc --timing --output Nobil-JSON.js --stringparam NN JSON2 Nobil-TEXT.xsl Nobiliario.xml
#
#  http://www.altova.com/
#  altovaxslt -xml Nobiliario.xml -xsl Nobil-TEXT.xsl -out Nobil-JSON.js -param NN=JSON2
#
#  http://www.unicorn-enterprises.com/
#  uxt /PNN=JSON2 Nobiliario.xml Nobil-TEXT.xsl Nobil-JSON.js
#
#  http://xmlstar.sf.net/
#  xml tr Nobil-TEXT.xsl -s NN=JSON2 Nobiliario.xml
#
#  http://xml.apache.org/
#  xalan ...
#
