<?xml version="1.0" encoding="iso-8859-1"?>
<!--  ================================================  -->
<!--  ================================================  -->
<!--  ================================================


      ================================================  -->
<!--  ================================================  -->
<!--  ================================================  -->

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xhtml="http://www.w3.org/1999/xhtml"
                xmlns:xlink="http://www.w3.org/1999/xlink"
                xmlns:adhoc="urn:xmlns:adhoc"
                xmlns:n="urn:xmlns:Nobiliario"
                >
<xsl:output method="text"
            media-type="text/plain"
            encoding="iso-8859-1" />

<!--  ================================================  -->
<!--  ================================================  -->
<!--  ================================================  -->

<xsl:param name="NN" select="''" />     <!-- generateNN  -->
<xsl:param name="CS" select="','" />    <!-- CS of CSVs (Standard Separator Character = ',') -->
<xsl:param name="JS" select="''" />     <!-- var $JS = ; -->
<xsl:variable name="NofNobItems"  select="count(//adhoc:list[1]/adhoc:item//n:Nobleza)" />
<xsl:variable name="NobilSTATS"><xsl:call-template name="generateStats" /></xsl:variable>

<!--  ================================================  -->
<!--  ================================================  -->

<xsl:variable name="GnomeXmlSoft" select="system-property('xsl:vendor')='libxml'" />
<xsl:variable name="TransforMiiX" select="system-property('xsl:vendor')='Transformiix'" />
<xsl:variable name="MicrosoftXML" select="system-property('xsl:vendor')='Microsoft'" />
<xsl:variable name="GingerSablot" select="system-property('xsl:vendor')='Ginger Alliance'" />
<xsl:variable name="OperaExpat"   select="system-property('xsl:vendor')='Opera'" />
<xsl:variable name="UnicornUXT"   select="contains(system-property('xsl:vendor'),'Unicorn')" />
<xsl:variable name="AltovaXSLT"   select="contains(system-property('xsl:vendor'),'Altova')" />
<xsl:variable name="InstantSAXON" select="contains(system-property('xsl:vendor'),'SAXON')" />

<!--  ================================================  -->
<!--  ================================================  -->


<!--  ================================================  -->
<!--  ================================================  -->
<!--  ================================================


      ================================================  -->
<!--  ================================================  -->
<!--  ================================================  -->

<xsl:template match="/">
    <xsl:choose>
        <xsl:when test="translate($NN,'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz')='json1'">
            <xsl:call-template name="generateJSON1" />
        </xsl:when>
        <xsl:when test="translate($NN,'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz')='json2'">
            <xsl:call-template name="generateJSON2" />
        </xsl:when>
        <xsl:when test="translate($NN,'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz')='csv'">
            <xsl:call-template name="generateCSV" />
        </xsl:when>
        <xsl:when test="$NN='TEXT'">
            <xsl:call-template name="generateTEXT" />
        </xsl:when>
        <xsl:otherwise>
            <xsl:text>&#xD;&#xA;</xsl:text>
            <xsl:value-of select="translate($NobilSTATS,'ܟ:','yaeiouaeiouaeiouanoaeiouyYAEIOUAEIOUAEIOUANOAEIOUY cC')" />
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template name="generateREM">
    <xsl:text>/*   ********************************************** &#xD;&#xA;</xsl:text>
    <xsl:text> *   JSON cf http://json.org/ &#xD;&#xA;</xsl:text>
    <xsl:text> *   JSON generated/transformed from Nobiliario.xml [built:</xsl:text><xsl:value-of select="/adhoc:AdHocDoc/@dateModified" /><xsl:text>] &#xD;&#xA;</xsl:text>
    <xsl:text> *   XML v</xsl:text><xsl:value-of select="system-property('xsl:version')" /> <xsl:text>&#xD;&#xA;</xsl:text>
    <xsl:text> *   XSLTransformed by &#xD;&#xA;</xsl:text>
    <xsl:text> *   </xsl:text><xsl:value-of select="system-property('xsl:vendor')" /> <xsl:text>&#xD;&#xA;</xsl:text>
    <xsl:text> *   </xsl:text><xsl:value-of select="system-property('xsl:vendor-url')" /> <xsl:text>&#xD;&#xA;</xsl:text>
    <xsl:text> */  </xsl:text>
</xsl:template>

<!--  ================================================  -->
<!--  ================================================  -->
<!--  ================================================  -->

<xsl:template name="LFtoCRLF">
    <xsl:param name="str" />
    <xsl:choose>
        <xsl:when test="contains($str,'&#xA;')">
            <xsl:value-of select="substring-before($str,'&#xA;')" /><xsl:text>&#xD;&#xA;</xsl:text>
            <xsl:call-template name="LFtoCRLF">
                <xsl:with-param name="str" select="substring-after($str,'&#xA;')" />
            </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
            <xsl:value-of select="$str" />
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template name="CRLFtoJS">
    <xsl:param name="str" />
    <xsl:choose>
        <xsl:when test="contains($str,'&#xD;&#xA;')">
            <xsl:value-of select="substring-before($str,'&#xD;&#xA;')" /><xsl:text>\r\n</xsl:text>
            <xsl:call-template name="CRLFtoJS">
                <xsl:with-param name="str" select="substring-after($str,'&#xD;&#xA;')" />
            </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
            <xsl:value-of select="$str" />
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template name="bslashESC">
    <xsl:param name="str" />
    <xsl:param name="esc" />
    <xsl:choose>
        <xsl:when test="contains($str,$esc)">
            <xsl:value-of select="substring-before($str,$esc)" /><xsl:text>\</xsl:text><xsl:value-of select="$esc" />
            <xsl:call-template name="bslashESC">
                <xsl:with-param name="str" select="substring-after($str,$esc)" />
                <xsl:with-param name="esc" select="$esc" />
            </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
            <xsl:value-of select="$str" />
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<!--  ================================================  -->
<!--  ================================================  -->
<!--  ================================================  -->

<xsl:decimal-format name="zeroY" NaN="0000" />
<xsl:decimal-format name="zeroM" NaN="00" />
<xsl:decimal-format name="zeroD" NaN="00" />
<xsl:decimal-format name="QMark" NaN="?" />
<xsl:decimal-format name="nineY" NaN="9999" />
<xsl:decimal-format name="nineM" NaN="99" />
<xsl:decimal-format name="nineD" NaN="99" />

<xsl:template name="leadingZero">
    <xsl:param name="val" />
    <xsl:param name="pfx" select="false()" />
    <xsl:if test="$pfx and $val!='?'"><xsl:text>&#x00FA;lt.</xsl:text></xsl:if>
    <xsl:if test="string-length($val)=1 and $val!='?'"><xsl:text>0</xsl:text></xsl:if>
    <xsl:value-of select="$val" />
</xsl:template>
<xsl:template name="standardDate">
    <xsl:param name="loc" select="." />
    <xsl:choose>
        <xsl:when test="$loc/adhoc:date/@ISO">
            <xsl:value-of select="$loc/adhoc:date/@ISO" />
        </xsl:when>
        <xsl:otherwise>
            <xsl:value-of select="concat($loc/adhoc:date/adhoc:y,'-',format-number($loc/adhoc:date/adhoc:m,'00','QMark'),'-',format-number($loc/adhoc:date/adhoc:d,'00','QMark'))" />
        </xsl:otherwise>
    </xsl:choose>
    <!--
    <xsl:value-of select="concat(format-number($loc/adhoc:date/adhoc:y,'0000','zeroY'),'-',format-number($loc/adhoc:date/adhoc:m,'00','zeroM'),'-',format-number($loc/adhoc:date/adhoc:d,'00','zeroD'))" />
    -->
</xsl:template>
<xsl:template name="shortISODateZero">
    <xsl:value-of select="number(translate(translate(./adhoc:date/@ISO,'-',''),'?','0'))" />
</xsl:template>
<xsl:template name="shortISODateNine">
    <xsl:value-of select="number(translate(translate(./adhoc:date/@ISO,'-',''),'?','9'))" />
</xsl:template>

<xsl:template name="countTitles">
    <xsl:choose>
        <xsl:when test="contains(@xhtml:class,'TMayor')">
            <xsl:value-of select="format-number(count(key('NobilXLINK',@xml:id))+1,'00')" />
        </xsl:when>
        <xsl:when test="contains(@xhtml:class,'TMenor')">
            <xsl:value-of select="format-number(count(key('NobilXLINK',substring-after(./n:Nota/n:vease/@xlink:href,'#')))+1,'00')" />
        </xsl:when>
        <xsl:otherwise>
            <xsl:text>00</xsl:text>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template name="ordinalSign">
    <xsl:choose>
        <xsl:when test="contains(@xhtml:class,'Mujer')">
            <xsl:text>&#x00AA;</xsl:text> <!--  -->
        </xsl:when>
        <xsl:when test="contains(@xhtml:class,'Varon')">
            <xsl:text>&#x00BA;</xsl:text> <!--  -->
        </xsl:when>
        <xsl:otherwise>
            <xsl:text>&#x00B0;</xsl:text> <!--  -->
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>


<xsl:key name="TokenData" match="//adhoc:data" use="@token" />

<xsl:template name="TokenText">
    <xsl:param name="cls" />
    <xsl:param name="txt" />
    <xsl:choose>
    <xsl:when test="contains($cls,' ')">
		<xsl:call-template name="TokenText">
			<xsl:with-param name="cls" select="substring-before($cls,' ')" />
			<xsl:with-param name="txt" select="$txt" />
		</xsl:call-template>
		<xsl:call-template name="TokenText">
			<xsl:with-param name="cls" select="substring-after($cls,' ')" />
			<xsl:with-param name="txt" select="$txt" />
		</xsl:call-template>
	</xsl:when>
    <xsl:when test="key('TokenData',$cls)"><xsl:value-of select="key('TokenData',$cls)/@title" /></xsl:when>
    <xsl:otherwise>
        <xsl:value-of select="$txt" />
    </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template name="TokenNote">
    <xsl:param name="cls" />
    <xsl:param name="txt" />
    <xsl:choose>
    <xsl:when test="contains($cls,' ')">
		<xsl:call-template name="TokenNote">
			<xsl:with-param name="cls" select="substring-before($cls,' ')" />
			<xsl:with-param name="txt" select="$txt" />
		</xsl:call-template>
		<xsl:call-template name="TokenNote">
			<xsl:with-param name="cls" select="substring-after($cls,' ')" />
			<xsl:with-param name="txt" select="$txt" />
		</xsl:call-template>
	</xsl:when>
    <xsl:when test="key('TokenData',$cls)"><xsl:value-of select="key('TokenData',$cls)/@notation" /></xsl:when>
    <xsl:otherwise>
        <xsl:value-of select="$txt" />
    </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<!--  ================================================  -->
<!--  ================================================  -->
<!--  ================================================  -->

<xsl:template name="hashIDREF">
    <xsl:text>&quot;IDREF&quot;:{ &#xD;&#xA;</xsl:text>
        <xsl:for-each select="//adhoc:list[1]/adhoc:item//n:Nobleza">
            <xsl:text>&quot;</xsl:text><xsl:value-of select="@xml:id" /><xsl:text>&quot;:</xsl:text><xsl:value-of select="position()-1" />
            <xsl:if test="not(position()=$NofNobItems)"><xsl:text>, </xsl:text></xsl:if>
        </xsl:for-each>
    <xsl:text>&#xD;&#xA;}, &#xD;&#xA;</xsl:text>
</xsl:template>

<xsl:template name="sortDesignation">
    <xsl:text>&quot;OrdenDenom&quot;:[ &#xD;&#xA;</xsl:text>
        <xsl:for-each select="//adhoc:list[1]/adhoc:item">
            <xsl:sort select=".//n:Denominacion" lang="es" data-type="text" />
            <xsl:value-of select="count(preceding-sibling::adhoc:item)" />
            <xsl:if test="not(position()=$NofNobItems)"><xsl:text>, </xsl:text></xsl:if>
        </xsl:for-each>
    <xsl:text>&#xD;&#xA;], &#xD;&#xA;</xsl:text>
</xsl:template>

<xsl:template name="sortCreation">
    <xsl:text>&quot;OrdenCreac&quot;:[ &#xD;&#xA;</xsl:text>
        <xsl:for-each select="//adhoc:list[1]/adhoc:item">
            <xsl:sort select="number(concat(format-number(.//n:Creacion/n:Instrumento[1]/adhoc:date/adhoc:y,'0000','nineY'),format-number(.//n:Creacion/n:Instrumento[1]/adhoc:date/adhoc:m,'00','nineM'),format-number(.//n:Creacion/n:Instrumento[1]/adhoc:date/adhoc:d,'00','nineD')))" data-type="number" order="ascending" />
            <xsl:value-of select="count(preceding-sibling::adhoc:item)" />
            <xsl:if test="not(position()=$NofNobItems)"><xsl:text>, </xsl:text></xsl:if>
        </xsl:for-each>
    <xsl:text>&#xD;&#xA;], &#xD;&#xA;</xsl:text>
</xsl:template>

<xsl:template name="sortGrandeur">
    <xsl:text>&quot;OrdenGdEsp&quot;:[ &#xD;&#xA;</xsl:text>
        <xsl:for-each select="//adhoc:list[1]/adhoc:item">
            <xsl:sort select="number(concat(format-number(.//n:Grandeza/n:Instrumento[1]/adhoc:date/adhoc:y,'0000','nineY'),format-number(.//n:Grandeza/n:Instrumento[1]/adhoc:date/adhoc:m,'00','nineM'),format-number(.//n:Grandeza/n:Instrumento[1]/adhoc:date/adhoc:d,'00','nineD')))" data-type="number" order="ascending" />
            <xsl:value-of select="count(preceding-sibling::adhoc:item)" />
            <xsl:if test="not(position()=$NofNobItems)"><xsl:text>, </xsl:text></xsl:if>
        </xsl:for-each>
    <xsl:text>&#xD;&#xA;], &#xD;&#xA;</xsl:text>
</xsl:template>

<xsl:template name="sortSur1stName">
    <xsl:text>&quot;OrdenNombre&quot;:[ &#xD;&#xA;</xsl:text>
        <xsl:for-each select="//adhoc:list[1]/adhoc:item">
            <xsl:sort select="concat(.//n:Titular/n:Nombre/n:Apellido/text()[last()],' ',.//n:Titular/n:Nombre/n:dePila)" lang="es" data-type="text" />
            <xsl:value-of select="count(preceding-sibling::adhoc:item)" />
            <xsl:if test="not(position()=$NofNobItems)"><xsl:text>, </xsl:text></xsl:if>
        </xsl:for-each>
    <xsl:text>&#xD;&#xA;], &#xD;&#xA;</xsl:text>
</xsl:template>

<xsl:template name="sortReverseDoc">
    <xsl:text>&quot;OrdenVerso&quot;:[ &#xD;&#xA;</xsl:text>
        <xsl:for-each select="//adhoc:list[1]/adhoc:item">
            <xsl:sort select="position()" data-type="number" order="descending" />
            <xsl:value-of select="count(preceding-sibling::adhoc:item)" />
            <xsl:if test="not(position()=$NofNobItems)"><xsl:text>, </xsl:text></xsl:if>
        </xsl:for-each>
    <xsl:text>&#xD;&#xA;], &#xD;&#xA;</xsl:text>
</xsl:template>

<xsl:template name="sortDateOfBirth">
    <xsl:text>&quot;OrdenNacen&quot;:[ &#xD;&#xA;</xsl:text>
        <xsl:for-each select="//adhoc:list[1]/adhoc:item">
            <xsl:sort select="number(concat(format-number(.//n:Titular/n:Nacimiento/adhoc:date/adhoc:y,'0000','nineY'),format-number(.//n:Titular/n:Nacimiento/adhoc:date/adhoc:m,'00','nineM'),format-number(.//n:Titular/n:Nacimiento/adhoc:date/adhoc:d,'00','nineD')))" data-type="number" order="ascending" />
            <xsl:value-of select="count(preceding-sibling::adhoc:item)" />
            <xsl:if test="not(position()=$NofNobItems)"><xsl:text>, </xsl:text></xsl:if>
        </xsl:for-each>
    <xsl:text>&#xD;&#xA;], &#xD;&#xA;</xsl:text>
</xsl:template>

<xsl:template name="sortNumber">
    <xsl:text>&quot;OrdenNumero&quot;:[ &#xD;&#xA;</xsl:text>
        <xsl:for-each select="//adhoc:list[1]/adhoc:item">
            <xsl:sort select="number(format-number(.//n:Numero,'00','zeroD'))" data-type="number" order="descending" />
            <xsl:value-of select="count(preceding-sibling::adhoc:item)" />
            <xsl:if test="not(position()=$NofNobItems)"><xsl:text>, </xsl:text></xsl:if>
        </xsl:for-each>
    <xsl:text>&#xD;&#xA;], &#xD;&#xA;</xsl:text>
</xsl:template>

<!--  ================================================  -->
<!--  ================================================  -->
<!--  ================================================

var Nobiliario = { // Nobiliario.Nob[#]["NN"]  or  Nobiliario.Nob[#].NN
    "ITEMS":# ,
    "STATS":"..." ,
    "IDREF":{"...":#,"...":#,...},
    "NobRev":"????-??-??" ,
    "OrdenDenom":[#,#,...] ,
    "OrdenCreac":[#,#,...] ,
    "OrdenGdEsp":[#,#,...] ,
    "OrdenNombre":[#,#,...] ,
    "OrdenNacen":[#,#,...] ,
    "OrdenNumero":[#,#,...] ,
    "Nob":[
        {
        "Sucesion":"..." ,
        "Titulo":"..." ,
            "Numero":"..." ,
            "Clase":"..." ,
            "Parte":"..." ,
            "Denom":"..." ,
        "Creacion":"..." ,
			"CreRdo":"..." ,
			"CreRdoID":"..." ,
        "Grandeza":"..." ,
			"GdERdo":"..." ,
			"GdERdoID":"..." ,
        "Titular":"..." ,
            "Nombre":"..." ,
                "Cortesia":"..." ,
                "dePila":"..." ,
                "Apellido":"..." ,
            "Nacencia":"..." ,
            "NacenAno":"..." ,
            "NacenMes":"..." ,
            "NacenDia":"..." ,
        "Titulos":"..." ,
        "XMLID":"..." ,
        "XLINK":"..." ,
        "NobCls":"..."
        } ,
        {
        ...
        }
    ]
};

      ================================================  -->
<!--  ================================================  -->
<!--  ================================================  -->

<xsl:template name="generateJSON1">
    <xsl:text>&#xD;&#xA;</xsl:text>
    <xsl:call-template name="generateREM" />
    <xsl:text>&#xD;&#xA;</xsl:text>
    <xsl:text>//   ~.Nob[#][&quot;NN&quot;]  or  ~.Nob[#].NN</xsl:text>
    <xsl:text>&#xD;&#xA;</xsl:text>
    <xsl:if test="$JS"><xsl:value-of select="concat('var ',$JS,' = ')" /></xsl:if><xsl:text>{</xsl:text>
    <xsl:text>&#xD;&#xA;</xsl:text>

    <xsl:text>&quot;ITEMS&quot;:</xsl:text>
        <xsl:value-of select="$NofNobItems" />
    <xsl:text>, &#xD;&#xA;</xsl:text>
    <xsl:text>&quot;STATS&quot;:&quot;</xsl:text>
        <xsl:call-template name="CRLFtoJS"><xsl:with-param name="str" select="translate($NobilSTATS,':',' ')" /></xsl:call-template>
    <xsl:text>&quot;, &#xD;&#xA;</xsl:text>
<!--
    <xsl:call-template name="hashIDREF" />
-->
    <xsl:text>&quot;NobRev&quot;:&quot;</xsl:text>
        <xsl:value-of select="/adhoc:AdHocDoc/@dateModified" />
    <xsl:text>&quot;, &#xD;&#xA;</xsl:text>

    <xsl:call-template name="sortDesignation" />
    <xsl:call-template name="sortCreation" />
    <xsl:call-template name="sortGrandeur" />
    <xsl:call-template name="sortSur1stName" />
    <xsl:call-template name="sortDateOfBirth" />
    <xsl:call-template name="sortNumber" />

    <xsl:text>&quot;Nob&quot;:[ &#xD;&#xA;</xsl:text>
        <xsl:for-each select="//adhoc:list[1]/adhoc:item//n:Nobleza">
            <xsl:text>{ &#xD;&#xA;</xsl:text>

            <xsl:text>&quot;Sucesion&quot;:&quot;</xsl:text>
                <xsl:call-template name="TokenNote">
                    <xsl:with-param name="cls" select="./n:Sucesion/n:Instrumento[1]/@xhtml:classid" />
                    <xsl:with-param name="txt" select="'ocu.'" />
                </xsl:call-template>
                <xsl:value-of select="./n:Sucesion/n:Instrumento[1]/@xhtml:class" />
                <xsl:text>.</xsl:text>
                <xsl:value-of select="./n:Sucesion/n:Instrumento[1]/adhoc:date/adhoc:y" />
                <xsl:text>-</xsl:text>
                <xsl:value-of select="format-number(./n:Sucesion/n:Instrumento[1]/adhoc:date/adhoc:m,'00','QMark')" />
                <xsl:text>-</xsl:text>
                <xsl:value-of select="format-number(./n:Sucesion/n:Instrumento[1]/adhoc:date/adhoc:d,'00','QMark')" />
            <xsl:text>&quot;, </xsl:text>
<!--
            <xsl:text>&quot;Titulo&quot;:&quot;</xsl:text>
                <xsl:value-of select="./n:Titulo/n:Clase" />
                <xsl:text> </xsl:text>
                <xsl:value-of select="./n:Titulo/n:Parte" />
                <xsl:text> </xsl:text>
                <xsl:value-of select="./n:Titulo/n:Denominacion" />
            <xsl:text>&quot;, </xsl:text>
-->
            <xsl:text>&quot;Numero&quot;:&quot;</xsl:text><xsl:call-template name="leadingZero"><xsl:with-param name="val" select="./n:Titulo/n:Numero" /></xsl:call-template><xsl:text>&quot;, </xsl:text>
            <xsl:text>&quot;Clase&quot;:&quot;</xsl:text><xsl:value-of select="./n:Titulo/n:Clase" /><xsl:text>&quot;, </xsl:text>
            <xsl:text>&quot;Parte&quot;:&quot;</xsl:text><xsl:value-of select="./n:Titulo/n:Parte" /><xsl:text>&quot;, </xsl:text>
            <xsl:text>&quot;Denom&quot;:&quot;</xsl:text><xsl:value-of select="./n:Titulo/n:Denominacion" /><xsl:text>&quot;, </xsl:text>

            <xsl:text>&quot;Creacion&quot;:&quot;</xsl:text>
                <xsl:text>cre.</xsl:text>
				<xsl:if test="./n:Creacion/n:Instrumento[1]/@xhtml:scope and not(contains(./n:Creacion/n:Instrumento[1]/@xhtml:class,./n:Creacion/n:Instrumento[1]/@xhtml:scope))"><xsl:value-of select="concat(./n:Creacion/n:Instrumento[1]/@xhtml:scope,'.')" /></xsl:if>
                <xsl:value-of select="translate(./n:Creacion/n:Instrumento[1]/@xhtml:class,' ','.')" />
                <xsl:text>.</xsl:text>
                <xsl:value-of select="./n:Creacion/n:Instrumento[1]/adhoc:date/adhoc:y" />
                <xsl:text>-</xsl:text>
                <xsl:value-of select="format-number(./n:Creacion/n:Instrumento[1]/adhoc:date/adhoc:m,'00','QMark')" />
                <xsl:text>-</xsl:text>
                <xsl:value-of select="format-number(./n:Creacion/n:Instrumento[1]/adhoc:date/adhoc:d,'00','QMark')" />
            <xsl:text>&quot;, </xsl:text>

			<!-- Reinado -->
            <xsl:text>&quot;CreRdo&quot;:&quot;</xsl:text>
				<xsl:choose>
					<xsl:when test="key('OrigenRdoID',./n:Creacion/@xhtml:rel)">
						<xsl:value-of select="key('OrigenRdoID',./n:Creacion/@xhtml:rel)/@xhtml:title" />
					</xsl:when>
					<xsl:otherwise><xsl:text>N.N.</xsl:text></xsl:otherwise>
				</xsl:choose>
            <xsl:text>&quot;, </xsl:text>
			
            <xsl:text>&quot;CreRdoID&quot;:&quot;</xsl:text>
                <xsl:value-of select="./n:Creacion/@xhtml:rel" />
            <xsl:text>&quot;, </xsl:text>
			<!-- Reinado -->

            <xsl:text>&quot;Grandeza&quot;:&quot;</xsl:text>
                <xsl:if test="./n:Grandeza">
                    <xsl:value-of select="./n:Grandeza/n:Instrumento[1]/@xhtml:classid" />
                    <xsl:text>.</xsl:text>
					<xsl:if test="./n:Grandeza/n:Instrumento[1]/@xhtml:scope and not(contains(./n:Grandeza/n:Instrumento[1]/@xhtml:class,./n:Grandeza/n:Instrumento[1]/@xhtml:scope))"><xsl:value-of select="concat(./n:Grandeza/n:Instrumento[1]/@xhtml:scope,'.')" /></xsl:if>
                    <xsl:value-of select="translate(./n:Grandeza/n:Instrumento[1]/@xhtml:class,' ','.')" />
                    <xsl:text>.</xsl:text>
                    <xsl:call-template name="standardDate">
                        <xsl:with-param name="loc" select="./n:Grandeza/n:Instrumento[1]" />
                    </xsl:call-template>
                </xsl:if>
            <xsl:text>&quot;, </xsl:text>

			<!-- Reinado -->
            <xsl:text>&quot;GdERdo&quot;:&quot;</xsl:text>
                <xsl:if test="./n:Grandeza">
					<xsl:if test="./n:Grandeza/@xhtml:rel!='' and ./n:Grandeza/@xhtml:rel!='NN.NN' and ./n:Grandeza/@xhtml:rel=./n:Creacion/@xhtml:rel"><xsl:text>[dem] </xsl:text></xsl:if>
					<xsl:choose>
						<xsl:when test="key('OrigenRdoID',./n:Grandeza/@xhtml:rel)">
							<xsl:value-of select="key('OrigenRdoID',./n:Grandeza/@xhtml:rel)/@xhtml:title" />
						</xsl:when>
						<xsl:otherwise><xsl:text>N.N.</xsl:text></xsl:otherwise>
					</xsl:choose>
                </xsl:if>
            <xsl:text>&quot;, </xsl:text>
			
            <xsl:text>&quot;GdERdoID&quot;:&quot;</xsl:text>
                <xsl:if test="./n:Grandeza">
					<xsl:value-of select="./n:Grandeza/@xhtml:rel" />
                </xsl:if>
            <xsl:text>&quot;, </xsl:text>
			<!-- Reinado -->
<!--
            <xsl:text>&quot;Nombre&quot;:&quot;</xsl:text>
                <xsl:choose>
                    <xsl:when test="contains(@xhtml:class,'Mujer')">
                        <xsl:text>Do&#x00F1;a </xsl:text>
                    </xsl:when>
                    <xsl:when test="contains(@xhtml:class,'Varon')">
                        <xsl:text>Don </xsl:text>
                    </xsl:when>
                </xsl:choose>
                <xsl:value-of select="./n:Titular/n:Nombre/n:dePila" />
                <xsl:text> </xsl:text>
                <xsl:value-of select="./n:Titular/n:Nombre/n:Apellido" />
            <xsl:text>&quot;, </xsl:text>
-->
            <xsl:text>&quot;Cortesia&quot;:&quot;</xsl:text>
                <xsl:choose>
                    <xsl:when test="./n:Titular/n:Nombre/n:Cortesia/text()='Do&#x00F1;a' and contains(@xhtml:class,'Mujer')">
                        <xsl:text>Do&#x00F1;a </xsl:text>
                    </xsl:when>
                    <xsl:when test="./n:Titular/n:Nombre/n:Cortesia/text()='Don' and contains(@xhtml:class,'Varon')">
                        <xsl:text>Don </xsl:text>
                    </xsl:when>
                </xsl:choose>
            <xsl:text>&quot;, </xsl:text>

            <xsl:text>&quot;dePila&quot;:&quot;</xsl:text><xsl:value-of select="./n:Titular/n:Nombre/n:dePila" /><xsl:text>&quot;, </xsl:text>
            <xsl:text>&quot;Apellido&quot;:&quot;</xsl:text><xsl:value-of select="./n:Titular/n:Nombre/n:Apellido" /><xsl:text>&quot;, </xsl:text>

            <xsl:text>&quot;Nacencia&quot;:&quot;</xsl:text>
                <xsl:call-template name="standardDate">
                    <xsl:with-param name="loc" select="./n:Titular/n:Nacimiento" />
                </xsl:call-template>
            <xsl:text>&quot;, </xsl:text>

            <xsl:text>&quot;NacenAno&quot;:&quot;</xsl:text><xsl:value-of select="format-number(./n:Titular/n:Nacimiento/adhoc:date/adhoc:y,'0000','QMark')" /><xsl:text>&quot;, </xsl:text>
            <xsl:text>&quot;NacenMes&quot;:&quot;</xsl:text><xsl:value-of select="format-number(./n:Titular/n:Nacimiento/adhoc:date/adhoc:m,'00','QMark')" /><xsl:text>&quot;, </xsl:text>
            <xsl:text>&quot;NacenDia&quot;:&quot;</xsl:text><xsl:value-of select="format-number(./n:Titular/n:Nacimiento/adhoc:date/adhoc:d,'00','QMark')" /><xsl:text>&quot;, </xsl:text>

            <xsl:text>&quot;Titulos&quot;:&quot;</xsl:text>
                <xsl:call-template name="countTitles" />
            <xsl:text>&quot;, </xsl:text>

            <xsl:text>&quot;XMLID&quot;:&quot;</xsl:text><xsl:value-of select="@xml:id" /><xsl:text>&quot;, </xsl:text>
            <xsl:text>&quot;XLINK&quot;:&quot;</xsl:text>
                <xsl:if test=".//n:vease/@xlink:href">
                    <xsl:value-of select=".//n:vease/@xlink:href" />
                    <xsl:if test="not(key('NobilXMLID',substring-after(.//n:vease/@xlink:href,'#')))">
                        <xsl:text>.(NOREF)</xsl:text> <!-- no referencia, not available/referable -->
                    </xsl:if>
                </xsl:if>
                <xsl:text>&quot;, </xsl:text>
            <xsl:text>&quot;NobCls&quot;:&quot;</xsl:text><xsl:value-of select="@xhtml:class" /><xsl:text>&quot;</xsl:text>

            <xsl:text>&#xD;&#xA;}</xsl:text>
            <xsl:if test="not(position()=$NofNobItems)"><xsl:text>, </xsl:text></xsl:if>
        </xsl:for-each>
    <xsl:text>&#xD;&#xA;]}</xsl:text><xsl:if test="$JS"><xsl:text>;</xsl:text></xsl:if>
    <xsl:text>&#xD;&#xA;//  end of obj/var &#xD;&#xA;&#xD;&#xA;</xsl:text>
    <xsl:text>&#xD;&#xA;</xsl:text>
</xsl:template>

<!--  ================================================  -->
<!--  ================================================  -->
<!--  ================================================

var Nobiliario = { // Nobiliario["NN"][#]  or  Nobiliario.NN[#]
    "ITEMS":# ,
    "STATS":"..." ,
    "IDREF":{"...":#,"...":#,...},
    "NobRev":"????-??-??" ,
    "OrdenDenom":[#,#,...] ,
    "OrdenCreac":["...","..."] ,
    "OrdenGdEsp":["...","..."] ,
    "OrdenNombre":[#,#,...] ,
    "OrdenNacen":[#,#,...] ,
    "OrdenNumero":[#,#,...] ,
    "Sucesion":["...","..."] ,
    "Titulo":["...","..."] ,
        "Numero":["...","..."] ,
        "Clase":["...","..."] ,
        "Parte":["...","..."] ,
        "Denom":["...","..."] ,
    "Creacion":["...","..."] ,
		"CreRdo":["...","..."] ,
		"CreRdoID":["...","..."] ,
    "Grandeza":["...","..."] ,
		"GdERdo":["...","..."] ,
		"GdERdoID":["...","..."] ,
    "Titular":["...","..."] ,
        "Nombre":["...","..."] ,
            "Cortesia":["...","..."] ,
            "dePila":["...","..."] ,
            "Apellido":["...","..."] ,
        "Nacencia":["...","..."] ,
        "NacenAno":["...","..."] ,
        "NacenMes":["...","..."] ,
        "NacenDia":["...","..."] ,
    "Titulos":["...","..."] ,
    "XMLID":["...","..."] ,
    "XLINK":["...","..."] ,
    "NobCls":["...","..."]
};

      ================================================  -->
<!--  ================================================  -->
<!--  ================================================  -->

<xsl:template name="generateJSON2">
    <xsl:text>&#xD;&#xA;</xsl:text>
    <xsl:call-template name="generateREM" />
    <xsl:text>&#xD;&#xA;</xsl:text>
    <xsl:text>//   ~[&quot;NN&quot;][#]  or  ~.NN[#]&#xD;&#xA;</xsl:text>
    <xsl:text>&#xD;&#xA;</xsl:text>
    <xsl:if test="$JS"><xsl:value-of select="concat('var ',$JS,' = ')" /></xsl:if><xsl:text>{</xsl:text>
    <xsl:text>&#xD;&#xA;</xsl:text>

    <xsl:text>&quot;ITEMS&quot;:</xsl:text>
        <xsl:value-of select="$NofNobItems" />
    <xsl:text>, &#xD;&#xA;</xsl:text>
    <xsl:text>&quot;STATS&quot;:&quot;</xsl:text>
        <xsl:call-template name="CRLFtoJS"><xsl:with-param name="str" select="translate($NobilSTATS,':',' ')" /></xsl:call-template>
    <xsl:text>&quot;, &#xD;&#xA;</xsl:text>
<!--
    <xsl:call-template name="hashIDREF" />
-->
    <xsl:text>&quot;NobRev&quot;:&quot;</xsl:text>
        <xsl:value-of select="/adhoc:AdHocDoc/@dateModified" />
    <xsl:text>&quot;, &#xD;&#xA;</xsl:text>

    <xsl:call-template name="sortDesignation" />
    <xsl:call-template name="sortCreation" />
    <xsl:call-template name="sortGrandeur" />
    <xsl:call-template name="sortSur1stName" />
    <xsl:call-template name="sortDateOfBirth" />
    <xsl:call-template name="sortNumber" />

    <xsl:text>&quot;Sucesion&quot;:[ &#xD;&#xA;</xsl:text>
        <xsl:for-each select="//adhoc:list[1]/adhoc:item//n:Nobleza/n:Sucesion/n:Instrumento[1]">
            <xsl:text>&quot;</xsl:text>
            <xsl:call-template name="TokenNote">
                <xsl:with-param name="cls" select="@xhtml:classid" />
                <xsl:with-param name="txt" select="'ocu.'" />
            </xsl:call-template>
            <xsl:value-of select="@xhtml:class" />
            <xsl:text>.</xsl:text>
            <xsl:call-template name="standardDate" />
            <xsl:text>&quot;</xsl:text>
            <xsl:if test="not(position()=$NofNobItems)"><xsl:text>, </xsl:text></xsl:if>
        </xsl:for-each>
    <xsl:text>&#xD;&#xA;], &#xD;&#xA;</xsl:text>
<!--
    <xsl:text>&quot;Titulo&quot;:[ &#xD;&#xA;</xsl:text>
        <xsl:for-each select="//adhoc:list[1]/adhoc:item//n:Titulo">
            <xsl:text>&quot;</xsl:text>
            <xsl:value-of select="./n:Clase" />
            <xsl:text> </xsl:text>
            <xsl:value-of select="./n:Parte" />
            <xsl:text> </xsl:text>
            <xsl:value-of select="./n:Denominacion" />
            <xsl:text>&quot;</xsl:text>
            <xsl:if test="not(position()=$NofNobItems)"><xsl:text>, </xsl:text></xsl:if>
        </xsl:for-each>
    <xsl:text>&#xD;&#xA;], &#xD;&#xA;</xsl:text>
-->
    <xsl:text>&quot;Denom&quot;:[ &#xD;&#xA;</xsl:text>
        <xsl:for-each select="//adhoc:list[1]/adhoc:item//n:Denominacion">
            <xsl:text>&quot;</xsl:text><xsl:value-of select="." /><xsl:text>&quot;</xsl:text>
            <xsl:if test="not(position()=$NofNobItems)"><xsl:text>, </xsl:text></xsl:if>
        </xsl:for-each>
    <xsl:text>&#xD;&#xA;], &#xD;&#xA;</xsl:text>

    <xsl:text>&quot;Clase&quot;:[ &#xD;&#xA;</xsl:text>
        <xsl:for-each select="//adhoc:list[1]/adhoc:item//n:Clase">
            <xsl:text>&quot;</xsl:text><xsl:value-of select="." /><xsl:text>&quot;</xsl:text>
            <xsl:if test="not(position()=$NofNobItems)"><xsl:text>, </xsl:text></xsl:if>
        </xsl:for-each>
    <xsl:text>&#xD;&#xA;], &#xD;&#xA;</xsl:text>

    <xsl:text>&quot;Parte&quot;:[ &#xD;&#xA;</xsl:text>
        <xsl:for-each select="//adhoc:list[1]/adhoc:item//n:Titulo">
            <xsl:text>&quot;</xsl:text><xsl:value-of select="./n:Parte" /><xsl:text>&quot;</xsl:text>
            <xsl:if test="not(position()=$NofNobItems)"><xsl:text>, </xsl:text></xsl:if>
        </xsl:for-each>
    <xsl:text>&#xD;&#xA;], &#xD;&#xA;</xsl:text>

    <xsl:text>&quot;Numero&quot;:[ &#xD;&#xA;</xsl:text>
        <xsl:for-each select="//adhoc:list[1]/adhoc:item//n:Titulo">
            <xsl:text>&quot;</xsl:text><xsl:call-template name="leadingZero"><xsl:with-param name="val" select="./n:Numero" /></xsl:call-template><xsl:text>&quot;</xsl:text>
            <xsl:if test="not(position()=$NofNobItems)"><xsl:text>, </xsl:text></xsl:if>
        </xsl:for-each>
    <xsl:text>&#xD;&#xA;], &#xD;&#xA;</xsl:text>

    <xsl:text>&quot;Creacion&quot;:[ &#xD;&#xA;</xsl:text>
        <xsl:for-each select="//adhoc:list[1]/adhoc:item//n:Creacion/n:Instrumento[1]">
            <xsl:text>&quot;cre.</xsl:text>
			<xsl:if test="@xhtml:scope and not(contains(@xhtml:class,@xhtml:scope))"><xsl:value-of select="concat(@xhtml:scope,'.')" /></xsl:if>
            <xsl:value-of select="translate(@xhtml:class,' ','.')" />
            <xsl:text>.</xsl:text>
            <xsl:call-template name="standardDate" />
            <xsl:text>&quot;</xsl:text>
            <xsl:if test="not(position()=$NofNobItems)"><xsl:text>, </xsl:text></xsl:if>
        </xsl:for-each>
    <xsl:text>&#xD;&#xA;], &#xD;&#xA;</xsl:text>

    <xsl:text>&quot;CreRdo&quot;:[ &#xD;&#xA;</xsl:text>
        <xsl:for-each select="//adhoc:list[1]/adhoc:item//n:Creacion">
			<!-- Reinado -->
            <xsl:text>&quot;</xsl:text>
			<xsl:choose>
				<xsl:when test="key('OrigenRdoID',@xhtml:rel)">
					<xsl:value-of select="key('OrigenRdoID',@xhtml:rel)/@xhtml:title" />
				</xsl:when>
				<xsl:otherwise><xsl:text>N.N.</xsl:text></xsl:otherwise>
			</xsl:choose>
			<xsl:text>&quot;</xsl:text>
			<!-- Reinado -->
            <xsl:if test="not(position()=$NofNobItems)"><xsl:text>, </xsl:text></xsl:if>
        </xsl:for-each>
    <xsl:text>&#xD;&#xA;], &#xD;&#xA;</xsl:text>

    <xsl:text>&quot;CreRdoID&quot;:[ &#xD;&#xA;</xsl:text>
        <xsl:for-each select="//adhoc:list[1]/adhoc:item//n:Creacion">
			<!-- Reinado -->
            <xsl:text>&quot;</xsl:text><xsl:value-of select="@xhtml:rel" /><xsl:text>&quot;</xsl:text>
			<!-- Reinado -->
            <xsl:if test="not(position()=$NofNobItems)"><xsl:text>, </xsl:text></xsl:if>
        </xsl:for-each>
    <xsl:text>&#xD;&#xA;], &#xD;&#xA;</xsl:text>

    <xsl:text>&quot;Grandeza&quot;:[ &#xD;&#xA;</xsl:text>
        <xsl:for-each select="//adhoc:list[1]/adhoc:item//n:Nobleza">
            <xsl:text>&quot;</xsl:text>
            <xsl:if test="./n:Grandeza">
                <xsl:value-of select="./n:Grandeza/n:Instrumento[1]/@xhtml:classid" />
                <xsl:text>.</xsl:text>
				<xsl:if test="./n:Grandeza/n:Instrumento[1]/@xhtml:scope and not(contains(./n:Grandeza/n:Instrumento[1]/@xhtml:class,./n:Grandeza/n:Instrumento[1]/@xhtml:scope))"><xsl:value-of select="concat(./n:Grandeza/n:Instrumento[1]/@xhtml:scope,'.')" /></xsl:if>
                <xsl:value-of select="translate(./n:Grandeza/n:Instrumento[1]/@xhtml:class,' ','.')" />
                <xsl:text>.</xsl:text>
                <xsl:call-template name="standardDate">
                    <xsl:with-param name="loc" select="./n:Grandeza/n:Instrumento[1]" />
                </xsl:call-template>
            </xsl:if>
            <xsl:text>&quot;</xsl:text>
            <xsl:if test="not(position()=$NofNobItems)"><xsl:text>, </xsl:text></xsl:if>
        </xsl:for-each>
    <xsl:text>&#xD;&#xA;], &#xD;&#xA;</xsl:text>

    <xsl:text>&quot;GdERdo&quot;:[ &#xD;&#xA;</xsl:text>
        <xsl:for-each select="//adhoc:list[1]/adhoc:item//n:Nobleza">
            <xsl:text>&quot;</xsl:text>
            <xsl:if test="./n:Grandeza">
				<!-- Reinado -->
				<xsl:if test="./n:Grandeza/@xhtml:rel!='' and ./n:Grandeza/@xhtml:rel!='NN.NN' and ./n:Grandeza/@xhtml:rel=./n:Creacion/@xhtml:rel"><xsl:text>[dem] </xsl:text></xsl:if>
				<xsl:choose>
					<xsl:when test="key('OrigenRdoID',./n:Grandeza/@xhtml:rel)">
						<xsl:value-of select="key('OrigenRdoID',./n:Grandeza/@xhtml:rel)/@xhtml:title" />
					</xsl:when>
					<xsl:otherwise><xsl:text>N.N.</xsl:text></xsl:otherwise>
				</xsl:choose>
				<!-- Reinado -->
            </xsl:if>
            <xsl:text>&quot;</xsl:text>
            <xsl:if test="not(position()=$NofNobItems)"><xsl:text>, </xsl:text></xsl:if>
        </xsl:for-each>
    <xsl:text>&#xD;&#xA;], &#xD;&#xA;</xsl:text>

    <xsl:text>&quot;GdERdoID&quot;:[ &#xD;&#xA;</xsl:text>
        <xsl:for-each select="//adhoc:list[1]/adhoc:item//n:Nobleza">
            <xsl:text>&quot;</xsl:text>
            <xsl:if test="./n:Grandeza">
				<!-- Reinado -->
				<xsl:value-of select="./n:Grandeza/@xhtml:rel" />
				<!-- Reinado -->
            </xsl:if>
            <xsl:text>&quot;</xsl:text>
            <xsl:if test="not(position()=$NofNobItems)"><xsl:text>, </xsl:text></xsl:if>
        </xsl:for-each>
    <xsl:text>&#xD;&#xA;], &#xD;&#xA;</xsl:text>
<!--
    <xsl:text>&quot;Nombre&quot;:[ &#xD;&#xA;</xsl:text>
        <xsl:for-each select="//adhoc:list[1]/adhoc:item//n:Titular/n:Nombre">
            <xsl:text>&quot;</xsl:text>
            <xsl:choose>
                <xsl:when test="contains(../../@xhtml:class,'Mujer')">
                    <xsl:text>Do&#x00F1;a </xsl:text>
                </xsl:when>
                <xsl:when test="contains(../../@xhtml:class,'Varon')">
                    <xsl:text>Don </xsl:text>
                </xsl:when>
            </xsl:choose>
            <xsl:value-of select="./n:dePila" />
            <xsl:text> </xsl:text>
            <xsl:value-of select="./n:Apellido" />
            <xsl:text>&quot;</xsl:text>
            <xsl:if test="not(position()=$NofNobItems)"><xsl:text>, </xsl:text></xsl:if>
        </xsl:for-each>
    <xsl:text>&#xD;&#xA;], &#xD;&#xA;</xsl:text>

    <xsl:text>&quot;Cortesia&quot;:[ &#xD;&#xA;</xsl:text>
        <xsl:for-each select="//adhoc:list[1]/adhoc:item//n:Nobleza">
            <xsl:text>&quot;</xsl:text>
            <xsl:choose>
                <xsl:when test="contains(@xhtml:class,'Mujer')">
                    <xsl:text>Do&#x00F1;a </xsl:text> 
                </xsl:when>
                <xsl:when test="contains(@xhtml:class,'Varon')">
                    <xsl:text>Don </xsl:text>
                </xsl:when>
            </xsl:choose>
            <xsl:text>&quot;</xsl:text>
            <xsl:if test="not(position()=$NofNobItems)"><xsl:text>, </xsl:text></xsl:if>
        </xsl:for-each>
    <xsl:text>&#xD;&#xA;], &#xD;&#xA;</xsl:text>
-->
    <xsl:text>&quot;Cortesia&quot;:[ &#xD;&#xA;</xsl:text>
        <xsl:for-each select="//adhoc:list[1]/adhoc:item//n:Titular/n:Nombre/n:Cortesia">
            <xsl:text>&quot;</xsl:text><xsl:if test="text()"><xsl:value-of select="concat(.,' ')" /></xsl:if><xsl:text>&quot;</xsl:text> <!-- Do&#x00F1;a = Doa / D.&#x00AA; = D. -->
            <xsl:if test="not(position()=$NofNobItems)"><xsl:text>, </xsl:text></xsl:if>
        </xsl:for-each>
    <xsl:text>&#xD;&#xA;], &#xD;&#xA;</xsl:text>

    <xsl:text>&quot;dePila&quot;:[ &#xD;&#xA;</xsl:text>
        <xsl:for-each select="//adhoc:list[1]/adhoc:item//n:Titular/n:Nombre/n:dePila">
            <xsl:text>&quot;</xsl:text><xsl:value-of select="." /><xsl:text>&quot;</xsl:text>
            <xsl:if test="not(position()=$NofNobItems)"><xsl:text>, </xsl:text></xsl:if>
        </xsl:for-each>
    <xsl:text>&#xD;&#xA;], &#xD;&#xA;</xsl:text>

    <xsl:text>&quot;Apellido&quot;:[ &#xD;&#xA;</xsl:text>
        <xsl:for-each select="//adhoc:list[1]/adhoc:item//n:Titular/n:Nombre/n:Apellido">
            <xsl:text>&quot;</xsl:text><xsl:value-of select="." /><xsl:text>&quot;</xsl:text>
            <xsl:if test="not(position()=$NofNobItems)"><xsl:text>, </xsl:text></xsl:if>
        </xsl:for-each>
    <xsl:text>&#xD;&#xA;], &#xD;&#xA;</xsl:text>

    <xsl:text>&quot;Nacencia&quot;:[ &#xD;&#xA;</xsl:text>
        <xsl:for-each select="//adhoc:list[1]/adhoc:item//n:Titular/n:Nacimiento">
            <xsl:text>&quot;</xsl:text>
            <xsl:call-template name="standardDate" />
            <xsl:text>&quot;</xsl:text>
            <xsl:if test="not(position()=$NofNobItems)"><xsl:text>, </xsl:text></xsl:if>
        </xsl:for-each>
    <xsl:text>&#xD;&#xA;], &#xD;&#xA;</xsl:text>

    <xsl:text>&quot;NacenAno&quot;:[ &#xD;&#xA;</xsl:text>
        <xsl:for-each select="//adhoc:list[1]/adhoc:item//n:Titular/n:Nacimiento/adhoc:date/adhoc:y">
            <xsl:text>&quot;</xsl:text><xsl:value-of select="format-number(.,'0000','QMark')" /><xsl:text>&quot;</xsl:text>
            <xsl:if test="not(position()=$NofNobItems)"><xsl:text>, </xsl:text></xsl:if>
        </xsl:for-each>
    <xsl:text>&#xD;&#xA;], &#xD;&#xA;</xsl:text>
    <xsl:text>&quot;NacenMes&quot;:[ &#xD;&#xA;</xsl:text>
        <xsl:for-each select="//adhoc:list[1]/adhoc:item//n:Titular/n:Nacimiento/adhoc:date/adhoc:m">
            <xsl:text>&quot;</xsl:text><xsl:value-of select="format-number(.,'00','QMark')" /><xsl:text>&quot;</xsl:text>
            <xsl:if test="not(position()=$NofNobItems)"><xsl:text>, </xsl:text></xsl:if>
        </xsl:for-each>
    <xsl:text>&#xD;&#xA;], &#xD;&#xA;</xsl:text>
    <xsl:text>&quot;NacenDia&quot;:[ &#xD;&#xA;</xsl:text>
        <xsl:for-each select="//adhoc:list[1]/adhoc:item//n:Titular/n:Nacimiento/adhoc:date/adhoc:d">
            <xsl:text>&quot;</xsl:text><xsl:value-of select="format-number(.,'00','QMark')" /><xsl:text>&quot;</xsl:text>
            <xsl:if test="not(position()=$NofNobItems)"><xsl:text>, </xsl:text></xsl:if>
        </xsl:for-each>
    <xsl:text>&#xD;&#xA;], &#xD;&#xA;</xsl:text>

    <xsl:text>&quot;Titulos&quot;:[ &#xD;&#xA;</xsl:text>
        <xsl:for-each select="//adhoc:list[1]/adhoc:item//n:Nobleza">
            <xsl:text>&quot;</xsl:text>
                <xsl:call-template name="countTitles" />
            <xsl:text>&quot;</xsl:text>
            <xsl:if test="not(position()=$NofNobItems)"><xsl:text>, </xsl:text></xsl:if>
        </xsl:for-each>
    <xsl:text>&#xD;&#xA;], &#xD;&#xA;</xsl:text>

    <xsl:text>&quot;XMLID&quot;:[ &#xD;&#xA;</xsl:text>
        <xsl:for-each select="//adhoc:list[1]/adhoc:item//n:Nobleza">
            <xsl:text>&quot;</xsl:text><xsl:value-of select="@xml:id" /><xsl:text>&quot;</xsl:text>
            <xsl:if test="not(position()=$NofNobItems)"><xsl:text>, </xsl:text></xsl:if>
        </xsl:for-each>
    <xsl:text>&#xD;&#xA;], &#xD;&#xA;</xsl:text>
    <xsl:text>&quot;XLINK&quot;:[ &#xD;&#xA;</xsl:text>
        <xsl:for-each select="//adhoc:list[1]/adhoc:item//n:Nobleza">
            <xsl:text>&quot;</xsl:text>
            <xsl:if test=".//n:vease/@xlink:href">
                <xsl:value-of select=".//n:vease/@xlink:href" />
                <xsl:if test="not(key('NobilXMLID',substring-after(.//n:vease/@xlink:href,'#')))">
                    <xsl:text>.(NOREF)</xsl:text> <!-- no referencia, not available/referable -->
                </xsl:if>
            </xsl:if>
            <xsl:text>&quot;</xsl:text>
            <xsl:if test="not(position()=$NofNobItems)"><xsl:text>, </xsl:text></xsl:if>
        </xsl:for-each>
    <xsl:text>&#xD;&#xA;], &#xD;&#xA;</xsl:text>
    <xsl:text>&quot;NobCls&quot;:[ &#xD;&#xA;</xsl:text>
        <xsl:for-each select="//adhoc:list[1]/adhoc:item//n:Nobleza">
            <xsl:text>&quot;</xsl:text><xsl:value-of select="@xhtml:class" /><xsl:text>&quot;</xsl:text>
            <xsl:if test="not(position()=$NofNobItems)"><xsl:text>, </xsl:text></xsl:if>
        </xsl:for-each>
    <xsl:text>&#xD;&#xA;]}</xsl:text><xsl:if test="$JS"><xsl:text>;</xsl:text></xsl:if>

    <xsl:text>&#xD;&#xA;//  end of obj/var &#xD;&#xA;&#xD;&#xA;</xsl:text>
    <xsl:text>&#xD;&#xA;</xsl:text>
</xsl:template>


<!--  ================================================  -->
<!--  ================================================  -->
<!--  ================================================

      CSV
	  
	  msxsl -xw -t Nobiliario.xml Nobil-TEXT.xsl -o Nobiliario.csv NN=CSV

      ================================================  -->
<!--  ================================================  -->
<!--  ================================================  -->


<xsl:template name="generateCSV">

    <xsl:value-of select="translate('ITEM,ID,TOKENS,Numero,Clase,Parte,Denominacion,ID.RdoCre,ReinadoCre,Creacion,ID.RdoGdE,ReinadoGdE,Grandeza,Cortesia,NombreDePila,NombreApellido,Nacimiento,Sucesion,Titulos,ITEM.Principal,IDREF.Principal,IDREFS.Vinculado&#xD;&#xA;',',',$CS)" />

    <xsl:for-each select="//adhoc:list[1]/adhoc:item//n:Nobleza">

        <xsl:value-of select="format-number(position(),'0000')" />

        <xsl:value-of select="$CS" />

        <xsl:value-of select="@xml:id" />

        <xsl:value-of select="$CS" />

        <xsl:text>&quot;</xsl:text>
        <xsl:value-of select="@xhtml:class" />
        <xsl:text>&quot;</xsl:text>

        <xsl:value-of select="$CS" />

        <xsl:if test="./n:Titulo/n:Numero">
        <xsl:text>&quot;</xsl:text>
            <xsl:call-template name="leadingZero"><xsl:with-param name="val" select="./n:Titulo/n:Numero" /></xsl:call-template>
            <xsl:call-template name="ordinalSign" />
        <xsl:text>&quot;</xsl:text>
        </xsl:if>

        <xsl:value-of select="$CS" />

        <xsl:text>&quot;</xsl:text>
        <xsl:value-of select="./n:Titulo/n:Clase" />
        <xsl:text>&quot;</xsl:text>

        <xsl:value-of select="$CS" />

        <xsl:text>&quot;</xsl:text>
        <xsl:value-of select="./n:Titulo/n:Parte" />
        <xsl:text>&quot;</xsl:text>

        <xsl:value-of select="$CS" />

        <xsl:text>&quot;</xsl:text>
        <xsl:value-of select="./n:Titulo/n:Denominacion" />
        <xsl:text>&quot;</xsl:text>

        <xsl:value-of select="$CS" />

        <xsl:value-of select="./n:Creacion/@xhtml:rel" />
		
		<xsl:value-of select="$CS" />
		
		<!-- Reinado -->
        <xsl:text>&quot;</xsl:text>
		<xsl:choose>
			<xsl:when test="key('OrigenRdoID',./n:Creacion/@xhtml:rel)">
				<xsl:value-of select="key('OrigenRdoID',./n:Creacion/@xhtml:rel)/@xhtml:title" />
			</xsl:when>
			<xsl:otherwise><xsl:text>N.N.</xsl:text></xsl:otherwise>
		</xsl:choose>
        <xsl:text>&quot;</xsl:text>
		<!-- Reinado -->

        <xsl:value-of select="$CS" />

        <xsl:text>&quot;</xsl:text>
        <xsl:for-each select="./n:Creacion/n:Instrumento">
            <xsl:text>(</xsl:text>
                <xsl:call-template name="standardDate" />
                <xsl:text>,cre.</xsl:text>
				<xsl:if test="@xhtml:scope and not(contains(@xhtml:class,@xhtml:scope))">
					<xsl:call-template name="TokenNote">
						<xsl:with-param name="cls" select="@xhtml:scope" />
						<xsl:with-param name="txt" select="'N.N.'" />
					</xsl:call-template>
				</xsl:if>
                <xsl:call-template name="TokenNote">
                    <xsl:with-param name="cls" select="@xhtml:class" />
                    <xsl:with-param name="txt" select="'N.N.'" />
                </xsl:call-template>
            <xsl:text>)</xsl:text>
        </xsl:for-each>
        <xsl:text>&quot;</xsl:text>

        <xsl:value-of select="$CS" />
		
        <xsl:choose>
            <xsl:when test="./n:Grandeza">
				<xsl:value-of select="./n:Grandeza/@xhtml:rel" />
				
				<xsl:value-of select="$CS" />
				
				<!-- Reinado -->
				<xsl:text>&quot;</xsl:text>
				<xsl:choose>
					<xsl:when test="key('OrigenRdoID',./n:Grandeza/@xhtml:rel)/@xhtml:title">
						<xsl:value-of select="key('OrigenRdoID',./n:Grandeza/@xhtml:rel)/@xhtml:title" />
					</xsl:when>
					<xsl:otherwise><xsl:text>N.N.</xsl:text></xsl:otherwise>
				</xsl:choose>
				<xsl:text>&quot;</xsl:text>
				<!-- Reinado -->
				
				<xsl:value-of select="$CS" />
				
				<xsl:text>&quot;</xsl:text>
				<xsl:for-each select="./n:Grandeza/n:Instrumento">
					<xsl:text>(</xsl:text>
						<xsl:call-template name="standardDate" />
						<xsl:text>,</xsl:text>
						<xsl:call-template name="TokenNote">
							<xsl:with-param name="cls" select="@xhtml:classid" />
							<xsl:with-param name="txt" select="'G.d.E.'" />
						</xsl:call-template>
						<xsl:text> </xsl:text>
						<xsl:if test="@xhtml:scope and not(contains(@xhtml:class,@xhtml:scope))">
							<xsl:call-template name="TokenNote">
								<xsl:with-param name="cls" select="@xhtml:scope" />
								<xsl:with-param name="txt" select="'N.N.'" />
							</xsl:call-template>
						</xsl:if>
						<xsl:call-template name="TokenNote">
							<xsl:with-param name="cls" select="@xhtml:class" />
							<xsl:with-param name="txt" select="'N.N.'" />
						</xsl:call-template>
					<xsl:text>)</xsl:text>
				</xsl:for-each>
				<xsl:text>&quot;</xsl:text>
            </xsl:when>
            <xsl:otherwise>
				<xsl:value-of select="$CS" />
				<xsl:value-of select="$CS" />
			</xsl:otherwise>
        </xsl:choose>

        <xsl:value-of select="$CS" />
<!--
        <xsl:choose>
            <xsl:when test="contains(@xhtml:class,'Mujer')">
                <xsl:text>&quot;Do&#x00F1;a&quot;</xsl:text> 
            </xsl:when>
            <xsl:when test="contains(@xhtml:class,'Varon')">
                <xsl:text>&quot;Don&quot;</xsl:text>
            </xsl:when>
        </xsl:choose>
-->
        <xsl:choose>
            <xsl:when test="./n:Titular/n:Nombre/n:Cortesia[text()]">
				<xsl:text>&quot;</xsl:text>
				<xsl:value-of select="./n:Titular/n:Nombre/n:Cortesia" /> <!-- Do&#x00F1;a = Doa / D.&#x00AA; = D. -->
				<xsl:text>&quot;</xsl:text>

				<xsl:value-of select="$CS" />

				<xsl:text>&quot;</xsl:text>
				<xsl:value-of select="./n:Titular/n:Nombre/n:dePila" />
				<xsl:text>&quot;</xsl:text>

				<xsl:value-of select="$CS" />

				<xsl:text>&quot;</xsl:text>
				<xsl:value-of select="./n:Titular/n:Nombre/n:Apellido" />
				<xsl:text>&quot;</xsl:text>
				
				<xsl:value-of select="$CS" />

				<xsl:for-each select="./n:Titular/n:Nacimiento">
					<xsl:call-template name="standardDate" />
				</xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
				<xsl:value-of select="$CS" />
				<xsl:value-of select="$CS" />
				<xsl:value-of select="$CS" />
			</xsl:otherwise>
        </xsl:choose>
		
        <xsl:value-of select="$CS" />

        <xsl:text>&quot;</xsl:text>
        <xsl:for-each select="./n:Sucesion/n:Instrumento">
            <xsl:text>(</xsl:text>
                <xsl:call-template name="standardDate" />
                <xsl:text>,</xsl:text>
                <xsl:call-template name="TokenNote">
                    <xsl:with-param name="cls" select="@xhtml:classid" />
                    <xsl:with-param name="txt" select="'ocu.'" />
                </xsl:call-template>
                <xsl:call-template name="TokenNote">
                    <xsl:with-param name="cls" select="@xhtml:class" />
                    <xsl:with-param name="txt" select="'N.N.'" />
                </xsl:call-template>
            <xsl:text>)</xsl:text>
        </xsl:for-each>
        <xsl:text>&quot;</xsl:text>

        <xsl:value-of select="$CS" />

        <xsl:call-template name="countTitles" />

        <xsl:value-of select="$CS" />

        <xsl:choose>
            <xsl:when test="./n:Nota/n:vease/@xlink:href">
                <xsl:if test="key('NobilXMLID',substring-after(./n:Nota/n:vease/@xlink:href,'#'))">
                    <xsl:value-of select="format-number(count(key('NobilXMLID',substring-after(./n:Nota/n:vease/@xlink:href,'#'))/preceding-sibling::adhoc:item)+1,'0000')" />
                </xsl:if>
                <xsl:value-of select="$CS" />
                <xsl:value-of select="substring-after(./n:Nota/n:vease/@xlink:href,'#')" />
            </xsl:when>
            <xsl:otherwise><xsl:value-of select="$CS" /></xsl:otherwise>
        </xsl:choose>

        <xsl:value-of select="$CS" />

        <xsl:if test="key('NobilXLINK',@xml:id)">
        <xsl:text>&quot;</xsl:text>
            <xsl:for-each select="key('NobilXLINK',@xml:id)">
                <xsl:text>(</xsl:text>
                <xsl:value-of select="format-number(count(./preceding-sibling::adhoc:item)+1,'0000')" />
                <xsl:text>,</xsl:text>
                <xsl:value-of select=".//n:Nobleza/@xml:id" />
                <xsl:text>)</xsl:text>
            </xsl:for-each>
        <xsl:text>&quot;</xsl:text>
        </xsl:if>

        <xsl:text>&#xD;&#xA;</xsl:text>

    </xsl:for-each>

</xsl:template>


<!--  ================================================  -->
<!--  ================================================  -->
<!--  ================================================

      msxsl -xw Nobiliario.xml Nobil-TEXT.xsl
      nxslt -xw Nobiliario.xml Nobil-TEXT.xsl

      saxon     Nobiliario.xml Nobil-TEXT.xsl
      sabcmd    Nobil-TEXT.xsl Nobiliario.xml
      xsltproc  Nobil-TEXT.xsl Nobiliario.xml
      uxt       Nobiliario.xml Nobil-TEXT.xsl stats.txt

      noop ?: altovaxslt -xml Nobiliario.xml -xsl Nobil-TEXT.xsl -out stats.txt
      noop ?: altovaxml -in Nobiliario.xml -xslt1 Nobil-TEXT.xsl -out stats.txt

      ================================================  -->
<!--  ================================================  -->
<!--  ================================================  -->

<xsl:key name="NobilXMLID" match="//adhoc:list[1]/adhoc:item" use=".//n:Nobleza/@xml:id" />
<xsl:key name="NobilXLINK" match="//adhoc:list[1]/adhoc:item" use="substring-after(.//n:Nobleza/n:Nota/n:vease/@xlink:href,'#')" />

<xsl:key name="NobilCLSID" match="//adhoc:list[1]/adhoc:item" use="substring-before(.//n:Nobleza/@xml:id,'.')" />
<xsl:key name="NobilCLASS" match="//adhoc:list[1]/adhoc:item" use="substring-before(.//n:Nobleza/@xhtml:class,' T')" />
<xsl:key name="GrandCLSID" match="//adhoc:list[1]/adhoc:item//n:Nobleza[contains(@xhtml:class,'conGdE')]" use="substring-before(@xml:id,'.')" />
<xsl:key name="GrandCLASS" match="//adhoc:list[1]/adhoc:item//n:Nobleza[contains(@xhtml:class,'conGdE')]" use="substring-before(@xhtml:class,' T')" />

<xsl:key name="OrigenRdoID" match="//n:Reinado"  use="@xml:id" />
<xsl:key name="OrigenCreID" match="//n:Creacion" use="@xhtml:rel" />
<xsl:key name="OrigenGdEID" match="//n:Grandeza" use="@xhtml:rel" />

<xsl:template name="generateStats">

    <xsl:variable name="NumSucesion"  select="count(//adhoc:list[1]/adhoc:item//n:Nobleza[contains(@xhtml:class,' TM')])" />
    <xsl:variable name="NumGrandeza"  select="count(//adhoc:list[1]/adhoc:item//n:Nobleza[contains(@xhtml:class,'conGdE')])" />
    <xsl:variable name="NumTitulosMayor"  select="count(//adhoc:list[1]/adhoc:item//n:Nobleza[contains(@xhtml:class,'TMayor')])" />
    <xsl:variable name="NumTitulosMenor"  select="count(//adhoc:list[1]/adhoc:item//n:Nobleza[contains(@xhtml:class,'TMenor')])" />
    <xsl:variable name="NumTitulosOtros"  select="count(//adhoc:list[1]/adhoc:item//n:Nobleza[contains(@xhtml:class,' Titu')])" />
    <xsl:variable name="NumMujeresMenor"  select="count(//adhoc:list[1]/adhoc:item//n:Nobleza[contains(@xhtml:class,'a TMenor')])" />
    <xsl:variable name="NumMujeresSuces"  select="count(//adhoc:list[1]/adhoc:item//n:Nobleza[contains(@xhtml:class,'a TM')])" />
    <xsl:variable name="NumMujeres"  select="count(//adhoc:list[1]/adhoc:item//n:Nobleza[contains(@xhtml:class,'a TMayor')])" />
    <xsl:variable name="NumTitulos"  select="$NofNobItems" />
    <xsl:variable name="NumTitulares"  select="$NumTitulosMayor" />
    <xsl:variable name="NumVaronesMenor"  select="number($NumTitulosMenor)-number($NumMujeresMenor)" />
    <xsl:variable name="NumVaronesSuces"  select="number($NumSucesion)-number($NumMujeresSuces)" />
    <xsl:variable name="NumVarones"  select="number($NumTitulares)-number($NumMujeres)" />
    <xsl:variable name="NumMujeresGdE"  select="count(//adhoc:list[1]/adhoc:item//n:Nobleza[contains(@xhtml:class,'Mujer conGdE')])" />
    <xsl:variable name="NumVaronesGdE"  select="count(//adhoc:list[1]/adhoc:item//n:Nobleza[contains(@xhtml:class,'Varon conGdE')])" />

    <xsl:variable name="NumSucConGdE"  select="count(//adhoc:list[1]/adhoc:item//n:Nobleza[contains(@xhtml:class,' TM') and contains(@xhtml:class,'conGdE')])" />
    <xsl:variable name="NumTMayorConGdE"  select="count(//adhoc:list[1]/adhoc:item//n:Nobleza[contains(@xhtml:class,'TMayor') and contains(@xhtml:class,'conGdE')])" />
    <xsl:variable name="NumTMenorConGdE"  select="count(//adhoc:list[1]/adhoc:item//n:Nobleza[contains(@xhtml:class,'TMenor') and contains(@xhtml:class,'conGdE')])" />
    <xsl:variable name="NumTOtrosConGdE"  select="count(//adhoc:list[1]/adhoc:item//n:Nobleza[contains(@xhtml:class,' Titu') and contains(@xhtml:class,'conGdE')])" />
    <xsl:variable name="NumMujMenConGdE"  select="count(//adhoc:list[1]/adhoc:item//n:Nobleza[contains(@xhtml:class,'a TMenor') and contains(@xhtml:class,'conGdE')])" />
    <xsl:variable name="NumMujSucConGdE"  select="count(//adhoc:list[1]/adhoc:item//n:Nobleza[contains(@xhtml:class,'a TM') and contains(@xhtml:class,'conGdE')])" />
    <xsl:variable name="NumMujMayConGdE"  select="count(//adhoc:list[1]/adhoc:item//n:Nobleza[contains(@xhtml:class,'a TMayor') and contains(@xhtml:class,'conGdE')])" />

    <xsl:variable name="NumMayConMen"  select="count(//adhoc:list[1]/adhoc:item//n:Nobleza[contains(@xhtml:class,'TMayor') and not(contains(@xhtml:title,'N01'))])" />
    <xsl:variable name="NumMaySinMen"  select="count(//adhoc:list[1]/adhoc:item//n:Nobleza[contains(@xhtml:class,'TMayor') and contains(@xhtml:title,'N01')])" />
    <xsl:variable name="NumMujMayConMen"  select="count(//adhoc:list[1]/adhoc:item//n:Nobleza[contains(@xhtml:class,'a TMayor') and not(contains(@xhtml:title,'N01'))])" />
    <xsl:variable name="NumMujMaySinMen"  select="count(//adhoc:list[1]/adhoc:item//n:Nobleza[contains(@xhtml:class,'a TMayor') and contains(@xhtml:title,'N01')])" />

    <xsl:variable name="NumTitulosCumul"  select="number($NumMayConMen)+number($NumTitulosMenor)" />
    <xsl:variable name="NumVaronesCumul"  select="number($NumMayConMen)-number($NumMujMayConMen)+number($NumVaronesMenor)" />
    <xsl:variable name="NumMujeresCumul"  select="number($NumMujMayConMen)+number($NumMujeresMenor)" />

    <xsl:value-of select="concat('      ',/adhoc:AdHocDoc/@dateModified,'                      M :   F :   X','&#xD;&#xA;')" />
    <xsl:value-of select="concat('      ---------------------------------------------','&#xD;&#xA;')" />
    <xsl:value-of select="concat('      Ttulos              ',$NumTitulos,'    ',$NumVaronesSuces,' : ',$NumMujeresSuces,' :',format-number($NumTitulosOtros,'0000'),'&#xD;&#xA;')" />
    <xsl:value-of select="concat('      Ttulos ocupados     ',$NumSucesion,'    ',$NumVaronesSuces,' : ',$NumMujeresSuces,' :   -&#xD;&#xA;')" />
    <xsl:value-of select="concat('      Ttulos principales  ',$NumTitulosMayor,'    ',$NumVarones,' : ',$NumMujeres,' :  [= Titulares]&#xD;&#xA;')" />
    <xsl:value-of select="concat('      Ttulos acumulados    ',$NumTitulosCumul,'     ',$NumVaronesCumul,' : ',$NumMujeresCumul,' :   -&#xD;&#xA;')" />
    <xsl:value-of select="concat('      Ttulos vinculados    ',$NumTitulosMenor,'     ',$NumVaronesMenor,' : ',format-number($NumMujeresMenor,'000'),' :   -&#xD;&#xA;')" />
    <xsl:value-of select="concat('      T.ppal. con T.vinc.   ',$NumMayConMen,'     ',number($NumMayConMen)-number($NumMujMayConMen),' :  ',$NumMujMayConMen,' :   -&#xD;&#xA;')" />
    <xsl:value-of select="concat('      T.ppal. sin T.vinc.  ',$NumMaySinMen,'    ',number($NumMaySinMen)-number($NumMujMaySinMen),' : ',$NumMujMaySinMen,' :   -&#xD;&#xA;')" />
    <xsl:value-of select="concat('      - Principados           ',count(key('NobilCLSID','Principado')),'       ',count(key('NobilCLASS','Principe')),' :   ',count(key('NobilCLASS','Princesa')),' :   ',count(key('NobilCLASS','Principado')),'&#xD;&#xA;')" />
    <xsl:value-of select="concat('      - Ducados             ',count(key('NobilCLSID','Ducado')),'     ',count(key('NobilCLASS','Duque')),' :  ',count(key('NobilCLASS','Duquesa')),' :  ',count(key('NobilCLASS','Ducado')),'&#xD;&#xA;')" />
    <xsl:value-of select="concat('        con G.d.E.          ',count(key('GrandCLSID','Ducado')),'     ',count(key('GrandCLASS','Duque')),' :  ',count(key('GrandCLASS','Duquesa')),' :  ',count(key('GrandCLASS','Ducado')),'&#xD;&#xA;')" />
    <xsl:value-of select="concat('      - Condados-Ducados      ',count(key('NobilCLSID','CondadoDucado')),'       ',count(key('NobilCLASS','Conde Duque')),' :   ',count(key('NobilCLASS','Condesa Duquesa')),' :   ',count(key('NobilCLASS','Condado Ducado')),'&#xD;&#xA;')" />
    <xsl:value-of select="concat('        con G.d.E.            ',count(key('GrandCLSID','CondadoDucado')),'       ',count(key('GrandCLASS','Conde Duque')),' :   ',count(key('GrandCLASS','Condesa Duquesa')),' :   ',count(key('GrandCLASS','Condado Ducado')),'&#xD;&#xA;')" />
    <xsl:value-of select="concat('      - Marquesados        ',count(key('NobilCLSID','Marquesado')),'     ',count(key('NobilCLASS','Marques')),' : ',count(key('NobilCLASS','Marquesa')),' : ',count(key('NobilCLASS','Marquesado')),'&#xD;&#xA;')" />
    <xsl:value-of select="concat('        con G.d.E.          ',count(key('GrandCLSID','Marquesado')),'     ',format-number(count(key('GrandCLASS','Marques')),'000'),' :  ',count(key('GrandCLASS','Marquesa')),' :  ',count(key('GrandCLASS','Marquesado')),'&#xD;&#xA;')" />
    <xsl:value-of select="concat('      - Condados           ',count(key('NobilCLSID','Condado')),'     ',count(key('NobilCLASS','Conde')),' : ',count(key('NobilCLASS','Condesa')),' : ',count(key('NobilCLASS','Condado')),'&#xD;&#xA;')" />
    <xsl:value-of select="concat('        con G.d.E.          ',count(key('GrandCLSID','Condado')),'      ',count(key('GrandCLASS','Conde')),' :  ',count(key('GrandCLASS','Condesa')),' :  ',format-number(count(key('GrandCLASS','Condado')),'00'),'&#xD;&#xA;')" />
    <xsl:value-of select="concat('      - Vizcondados         ',count(key('NobilCLSID','Vizcondado')),'     ',format-number(count(key('NobilCLASS','Vizconde')),'000'),' :  ',count(key('NobilCLASS','Vizcondesa')),' :  ',count(key('NobilCLASS','Vizcondado')),'&#xD;&#xA;')" />
    <xsl:value-of select="concat('        con G.d.E.            ',count(key('GrandCLSID','Vizcondado')),'       ',count(key('GrandCLASS','Vizconde')),' :   ',count(key('GrandCLASS','Vizcondesa')),' :   ',count(key('GrandCLASS','Vizcondado')),'&#xD;&#xA;')" />
    <xsl:value-of select="concat('      - Baronas            ',count(key('NobilCLSID','Baronia')),'     ',count(key('NobilCLASS','Baron')),' :  ',count(key('NobilCLASS','Baronesa')),' : ',format-number(count(key('NobilCLASS','Baronia')),'000'),'&#xD;&#xA;')" />
    <xsl:value-of select="concat('        con G.d.E.            ',count(key('GrandCLSID','Baronia')),'       ',count(key('GrandCLASS','Baron')),' :   ',count(key('GrandCLASS','Baronesa')),' :   ',count(key('GrandCLASS','Baronia')),'&#xD;&#xA;')" />
    <xsl:value-of select="concat('      - Seoros              ',count(key('NobilCLSID','Senorio')),'       ',count(key('NobilCLASS','Senor')),' :   ',count(key('NobilCLASS','Senora')),' :   ',count(key('NobilCLASS','Senorio')),'&#xD;&#xA;')" />
    <xsl:value-of select="concat('        con G.d.E.            ',count(key('GrandCLSID','Senorio')),'       ',count(key('GrandCLASS','Senor')),' :   ',count(key('GrandCLASS','Senora')),' :   ',count(key('GrandCLASS','Senorio')),'&#xD;&#xA;')" />
    <xsl:value-of select="concat('      - Dignidades de G.d.E.  ',count(key('NobilCLSID','Grandeza')),'       ',count(key('NobilCLASS','Grande')),' :   ',count(key('NobilCLASS','Grandesa')),' :   ',count(key('NobilCLASS','Grandeza')),'&#xD;&#xA;')" />
    <xsl:value-of select="concat('      - Mariscalatos          ',count(key('NobilCLSID','Mariscalato')),'       ',count(key('NobilCLASS','Mariscal')),' :   ',count(key('NobilCLASS','Mariscala')),' :   ',count(key('NobilCLASS','Mariscalato')),'&#xD;&#xA;')" />
    <xsl:value-of select="concat('      - Almirantazgos         ',count(key('NobilCLSID','Almirantazgo')),'       ',count(key('NobilCLASS','Almirante')),' :   ',count(key('NobilCLASS','Almiranta')),' :   ',count(key('NobilCLASS','Almirantazgo')),'&#xD;&#xA;')" />
    <xsl:value-of select="concat('      - Adelantamientos       ',count(key('NobilCLSID','Adelantamiento')),'       ',count(key('NobilCLASS','Adelantado')),' :   ',count(key('NobilCLASS','Adelantada')),' :   ',count(key('NobilCLASS','Adelantamiento')),'&#xD;&#xA;')" />
    <xsl:value-of select="concat('      Grandezas de Espaa   ',$NumGrandeza,'     ',$NumVaronesGdE,' : ',format-number($NumMujeresGdE,'000'),' :  ',number($NumGrandeza)-number($NumVaronesGdE)-number($NumMujeresGdE),'&#xD;&#xA;')" />
    <xsl:value-of select="concat('      G.d.E. T.ocupados     ',$NumSucConGdE,'     ',number($NumSucConGdE)-number($NumMujSucConGdE),' : ',format-number($NumMujSucConGdE,'000'),' :   -&#xD;&#xA;')" />
    <xsl:value-of select="concat('      G.d.E. T.principales  ',$NumTMayorConGdE,'     ',number($NumTMayorConGdE)-number($NumMujMayConGdE),' :  ',$NumMujMayConGdE,' :   -&#xD;&#xA;')" />
    <xsl:value-of select="concat('      G.d.E. T.vinculados    ',$NumTMenorConGdE,'      ',number($NumTMenorConGdE)-number($NumMujMenConGdE),' :  ',format-number($NumMujMenConGdE,'00'),' :   -&#xD;&#xA;')" />
	<!--
    <xsl:value-of select="concat('      Titulares:           ',$NumTitulares,'    ',$NumVarones,' : ',$NumMujeres,' :   -&#xD;&#xA;')" />
      -->
    <xsl:value-of select="concat('      ---------------------------------------------','&#xD;&#xA;&#xD;&#xA;')" />
    <xsl:value-of select="concat('      Cre/Ocu/GdE   Perodo/Reinado           Texto ~ ID [Otorgante.Origen/Regin/Estado]','&#xD;&#xA;')" />
    <xsl:value-of select="concat('      -----------------------------------------------------------------------------------','&#xD;&#xA;')" />
    <xsl:for-each select="//n:Reinado">
		<xsl:sort select="number(concat(format-number(.//adhoc:date[1]/adhoc:y[1],'0000','zeroY'),format-number(.//adhoc:date[1]/adhoc:m[1],'00','zeroM'),format-number(.//adhoc:date[1]/adhoc:d[1],'00','zeroD')))" data-type="number" order="ascending" />
		<xsl:value-of select="concat('      ',translate(substring-after(@xhtml:value,'_'),'_',' '),'   ',.//adhoc:date[1]/@ISO,' - ',.//adhoc:to[last()]/@ISO,'   ',@xhtml:title,' ~ ',@xml:id,'&#xD;&#xA;')" />
	</xsl:for-each>
</xsl:template>

<!--  ================================================  -->
<!--  ================================================  -->
<!--  ================================================

		msxsl -xw -t Nobiliario.xml Nobil-TEXT.xsl NN=TEXT | tee Nobiliario.txt | ssed -f Nobiliario.xht.sed | tee Nobiliario.txt.htm | gzip -9cv > Nobiliario.txt.htm.gz

		posicin ####|ID| : instrumento 'nnn.NN.fecha' de sucesin/situacin : nmero clase parte denominacin : por reinado/otorgante e instrumento 'cre.NN.fecha' de creacin : por reinado/otorgante e instrumento 'G.d.E.NN.fecha' de grandeza de espaa : cortesa y nombre de pila y apellido : *nacimiento : vase ppal./vinc. posicin ####|ID| ttulo principal denominacin, clase parte

      ================================================  -->
<!--  ================================================  -->
<!--  ================================================  -->

<xsl:template name="generateTEXT">
    <xsl:for-each select="//adhoc:list[1]/adhoc:item//n:Nobleza">

        <xsl:value-of select="concat(format-number(position(),'0000'),'|',@xml:id,'|')" /><xsl:text> : </xsl:text>

        <xsl:for-each select="./n:Sucesion/n:Instrumento">
            <xsl:call-template name="TokenNote">
                <xsl:with-param name="cls" select="@xhtml:classid" />
                <xsl:with-param name="txt" select="'ocu.'" />
            </xsl:call-template>
            <xsl:call-template name="TokenNote">
                <xsl:with-param name="cls" select="@xhtml:class" />
                <xsl:with-param name="txt" select="'N.N.'" />
            </xsl:call-template>
            <xsl:call-template name="standardDate" />
            <xsl:text> </xsl:text>
        </xsl:for-each>

        <xsl:text>: </xsl:text>

        <xsl:if test="./n:Titulo/n:Numero">
            <xsl:call-template name="leadingZero"><xsl:with-param name="pfx" select="contains(@xhtml:class,'Titu')" /><xsl:with-param name="val" select="./n:Titulo/n:Numero" /></xsl:call-template>
            <xsl:call-template name="ordinalSign" />
            <xsl:text> </xsl:text>
        </xsl:if>

        <xsl:value-of select="./n:Titulo/n:Clase" />
        <xsl:text> </xsl:text>
        <xsl:value-of select="./n:Titulo/n:Parte" />
        <xsl:text> </xsl:text>
        <xsl:value-of select="./n:Titulo/n:Denominacion" />

        <xsl:text> : </xsl:text>

		<!-- Reinado -->
        <xsl:text>por </xsl:text>
		<xsl:choose>
			<xsl:when test="key('OrigenRdoID',./n:Creacion/@xhtml:rel)">
				<xsl:value-of select="key('OrigenRdoID',./n:Creacion/@xhtml:rel)/@xhtml:title" />
			</xsl:when>
			<xsl:otherwise><xsl:text>N.N.</xsl:text></xsl:otherwise>
		</xsl:choose>
        <xsl:text> </xsl:text>
		<!-- Reinado -->

        <xsl:for-each select="./n:Creacion/n:Instrumento">
            <xsl:text>cre.</xsl:text>
			<xsl:if test="@xhtml:scope and not(contains(@xhtml:class,@xhtml:scope))">
				<xsl:call-template name="TokenNote">
					<xsl:with-param name="cls" select="@xhtml:scope" />
					<xsl:with-param name="txt" select="'N.N.'" />
				</xsl:call-template>
			</xsl:if>
            <xsl:call-template name="TokenNote">
                <xsl:with-param name="cls" select="@xhtml:class" />
                <xsl:with-param name="txt" select="'N.N.'" />
            </xsl:call-template>
            <xsl:call-template name="standardDate" />
            <xsl:text> </xsl:text>
        </xsl:for-each>

        <xsl:text>: </xsl:text>

        <xsl:choose>
            <xsl:when test="./n:Grandeza">
			<!-- Reinado -->
			<xsl:text>por </xsl:text>
			<xsl:if test="./n:Grandeza/@xhtml:rel!='' and ./n:Grandeza/@xhtml:rel!='NN.NN' and ./n:Grandeza/@xhtml:rel=./n:Creacion/@xhtml:rel"><xsl:text>[dem] </xsl:text></xsl:if>
			<xsl:choose>
				<xsl:when test="key('OrigenRdoID',./n:Grandeza/@xhtml:rel)">
					<xsl:value-of select="key('OrigenRdoID',./n:Grandeza/@xhtml:rel)/@xhtml:title" />
				</xsl:when>
				<xsl:otherwise><xsl:text>N.N.</xsl:text></xsl:otherwise>
			</xsl:choose>
			<xsl:text> </xsl:text>
			<!-- Reinado -->
            <xsl:text>con </xsl:text>
            <xsl:for-each select="./n:Grandeza/n:Instrumento">
                    <xsl:call-template name="TokenNote">
                        <xsl:with-param name="cls" select="@xhtml:classid" />
                        <xsl:with-param name="txt" select="'G.d.E.'" />
                    </xsl:call-template>
                    <xsl:text> </xsl:text>
					<xsl:if test="@xhtml:scope and not(contains(@xhtml:class,@xhtml:scope))">
						<xsl:call-template name="TokenNote">
							<xsl:with-param name="cls" select="@xhtml:scope" />
							<xsl:with-param name="txt" select="'N.N.'" />
						</xsl:call-template>
						<xsl:text> </xsl:text>
					</xsl:if>
                    <xsl:call-template name="TokenNote">
                        <xsl:with-param name="cls" select="@xhtml:class" />
                        <xsl:with-param name="txt" select="'N.N.'" />
                    </xsl:call-template>
                    <xsl:call-template name="standardDate" />
                <xsl:text> </xsl:text>
            </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>sin G.d.E. </xsl:text>
            </xsl:otherwise>
        </xsl:choose>
		
		<xsl:if test="contains($SucesoGdEPC,concat('|',@xml:id,'|'))">
			<xsl:call-template name="Suceso4ID"><xsl:with-param name="ID" select="@xml:id" /></xsl:call-template>
		</xsl:if>

        <xsl:if test="./n:Titular/n:Nombre/n:Cortesia[text()]">
			<xsl:text>: </xsl:text>
			<xsl:value-of select="./n:Titular/n:Nombre/n:Cortesia" />
            <xsl:text> </xsl:text>
			<xsl:value-of select="./n:Titular/n:Nombre/n:dePila" />
			<xsl:text> </xsl:text>
			<xsl:value-of select="./n:Titular/n:Nombre/n:Apellido" />
			<xsl:text> : *</xsl:text>
			<xsl:for-each select="./n:Titular/n:Nacimiento">
				<xsl:call-template name="standardDate" />
			</xsl:for-each>
        </xsl:if>

        <xsl:if test="./n:Nota/n:vease/@xlink:href">
            <xsl:text> : v.ppal. </xsl:text>
            <xsl:if test="key('NobilXMLID',substring-after(./n:Nota/n:vease/@xlink:href,'#'))">
                <xsl:value-of select="format-number(count(key('NobilXMLID',substring-after(./n:Nota/n:vease/@xlink:href,'#'))/preceding-sibling::adhoc:item)+1,'0000')" />
				<xsl:value-of select="concat('|',substring-after(./n:Nota/n:vease/@xlink:href,'#'),'|')" />
            </xsl:if>
            <xsl:text> </xsl:text>
            <xsl:value-of select="./n:Nota/n:vease" />
        </xsl:if>

        <xsl:if test="key('NobilXLINK',@xml:id)">
            <xsl:text> : v.vinc.</xsl:text>
            <xsl:for-each select="key('NobilXLINK',@xml:id)">
                <xsl:text> </xsl:text>
                <xsl:value-of select="format-number(count(./preceding-sibling::adhoc:item)+1,'0000')" />
				<xsl:value-of select="concat('|',.//@xml:id,'|')" />
            </xsl:for-each>
        </xsl:if>

        <xsl:text>&#xD;&#xA;</xsl:text>

    </xsl:for-each>

    <xsl:text>&#xD;&#xA;</xsl:text>
    <xsl:text>=================================================== &#xD;&#xA;</xsl:text>
	<xsl:text>Project ID/Main: NobiliarioEspanol ~ Nobiliario.html&#xD;&#xA;</xsl:text>
	<xsl:text>Generic URI/Home: http://unterstein.net/NobiliarioEspanol &#xD;&#xA;</xsl:text>
    <xsl:text>=================================================== &#xD;&#xA;</xsl:text>
    <xsl:text>Nobiliario Espaol  [Copyright (c) </xsl:text><xsl:value-of select="substring-before(/adhoc:AdHocDoc/@dateModified,'-')" /><xsl:text> ff. O.Rost]; ltima actualizacin </xsl:text><xsl:value-of select="/adhoc:AdHocDoc/@dateModified" /><xsl:text> &#xD;&#xA;</xsl:text>
    <xsl:text>Relacin de todos los titulares actuales en orden cronolgico de la primera cdula de sucesin &#xD;&#xA;</xsl:text>
	<xsl:text>       y de otros ttulos en orden cronolgico de situaciones no ocupados (vacante, cancelado, renunciado, anulado, caducado, suprimido, revertido o extinguido) &#xD;&#xA;</xsl:text>
    <xsl:text>=================================================== &#xD;&#xA;</xsl:text>
    <xsl:value-of select="translate($NobilSTATS,':',' ')" />
    <xsl:text>=================================================== &#xD;&#xA;</xsl:text>
    <xsl:text>Abreviaturas/Instrumentos:&#xD;&#xA;</xsl:text>
    <xsl:text>BO      = B.O.       = Boletn Oficial del Estado &#xD;&#xA;</xsl:text>
    <xsl:text>CC      = C.C.       = (a consulta de la) Cmara de Castilla &#xD;&#xA;</xsl:text>
    <xsl:text>CCa     = C.Ca.      = (a consulta de los) Cortes de Cdiz &#xD;&#xA;</xsl:text>
    <xsl:text>CConf   = C.Conf.    = Carta de Confirmacin &#xD;&#xA;</xsl:text>
    <xsl:text>CI      = C.I.       = (a consulta de la) Cmara de Indias &#xD;&#xA;</xsl:text>
    <xsl:text>CoR     = Co.R.      = Consejo de Regencia &#xD;&#xA;</xsl:text>
    <xsl:text>CP      = C.P.       = Carta Pontificia (Breve) &#xD;&#xA;</xsl:text>
    <xsl:text>CPS     = C.P.S.     = Carta Pontificia de Sucesin &#xD;&#xA;</xsl:text>
    <xsl:text>CR      = C.R.       = Carta de Rehabilitacin &#xD;&#xA;</xsl:text>
    <xsl:text>CS      = C.S.       = Carta de Sucesin &#xD;&#xA;</xsl:text>
    <xsl:text>C       = C.         = Carta &#xD;&#xA;</xsl:text>
    <xsl:text>D       = D.         = Decreto &#xD;&#xA;</xsl:text>
    <xsl:text>DespA   = Desp.A.    = Despacho de Autorizacin &#xD;&#xA;</xsl:text>
    <xsl:text>OA      = O.A.       = Orden de Autorizacin &#xD;&#xA;</xsl:text>
    <xsl:text>RA      = R.A.       = Real Autorizacin &#xD;&#xA;</xsl:text>
    <xsl:text>RC      = R.C.       = Real Cdula &#xD;&#xA;</xsl:text>
    <xsl:text>RCR     = R.C.R.     = Real Carta de Rehabilitacin &#xD;&#xA;</xsl:text>
    <xsl:text>RCS     = R.C.S.     = Real Carta de Sucesin &#xD;&#xA;</xsl:text>
    <xsl:text>RD      = R.D.       = Real Decreto &#xD;&#xA;</xsl:text>
    <xsl:text>RDR     = R.D.R.     = Real Decreto de Rehabilitacin &#xD;&#xA;</xsl:text>
    <xsl:text>RDesp   = R.Desp.    = Real Despacho &#xD;&#xA;</xsl:text>
    <xsl:text>RF      = R.F.       = Real Facultad &#xD;&#xA;</xsl:text>
    <xsl:text>RO      = R.O.       = Real Orden &#xD;&#xA;</xsl:text>
    <xsl:text>RP      = R.P.       = Real Privilegio &#xD;&#xA;</xsl:text>
    <xsl:text>SJ      = S.J.       = Sentencia judicial &#xD;&#xA;</xsl:text>

    <xsl:text>TAra    = T.Ara.     = Ttulo de Aragn &#xD;&#xA;</xsl:text>
    <xsl:text>TAus    = T.Aus.     = Ttulo de Austria &#xD;&#xA;</xsl:text>
    <xsl:text>TBar    = T.Bar.     = Ttulo de Barcelona &#xD;&#xA;</xsl:text>
    <xsl:text>TCas    = T.Cas.     = Ttulo de Castilla &#xD;&#xA;</xsl:text>
    <xsl:text>TCer    = T.Cer.     = Ttulo de Cerdea &#xD;&#xA;</xsl:text>
    <xsl:text>TEsp    = T.Esp.     = Ttulo de Espaa &#xD;&#xA;</xsl:text>
    <xsl:text>TEspB   = T.Esp.B.   = Ttulo Bonapartista &#xD;&#xA;</xsl:text>
    <xsl:text>TEspC   = T.Esp.C.   = Ttulo Carlista &#xD;&#xA;</xsl:text>
    <xsl:text>TEspF   = T.Esp.F.   = Ttulo Franquista &#xD;&#xA;</xsl:text>
    <xsl:text>TEspGP  = T.Esp.G.P. = Ttulo del Gobierno Provisional &#xD;&#xA;</xsl:text>
    <xsl:text>TEspI   = T.Esp.Ind. = Ttulo de Indias (por los Reyes de Espaa) &#xD;&#xA;</xsl:text>
    <xsl:text>TEspIGP = T.Esp.Ind.G.P. = Ttulo de Indias (por el Gobierno Provisional) &#xD;&#xA;</xsl:text>
    <xsl:text>TEspP   = T.Esp.P.   = Ttulo del Archiduque Pretendiente Don Carlos de Austria &#xD;&#xA;</xsl:text>
    <xsl:text>Tfeud   = T.feud.    = Ttulo (del antiguo territorio) feudal &#xD;&#xA;</xsl:text>
    <xsl:text>TFla    = T.Fla.     = Ttulo de Flandes &#xD;&#xA;</xsl:text>
    <xsl:text>TFra    = T.Fra.     = Ttulo de Francia &#xD;&#xA;</xsl:text>
    <xsl:text>TInd    = T.Ind.     = Ttulo de Indias &#xD;&#xA;</xsl:text>
    <xsl:text>TIng    = T.Ing.     = Ttulo de Inglaterra &#xD;&#xA;</xsl:text>
    <xsl:text>TIta    = T.Ita.     = Ttulo de Italia &#xD;&#xA;</xsl:text>
    <xsl:text>TLuc    = T.Luc.     = Ttulo de Lucca &#xD;&#xA;</xsl:text>
    <xsl:text>TMal    = T.Mal.     = Ttulo de Mallorca &#xD;&#xA;</xsl:text>
    <xsl:text>TMil    = T.Mil.     = Ttulo de Miln &#xD;&#xA;</xsl:text>
    <xsl:text>TNap    = T.Nap.     = Ttulo de Npoles &#xD;&#xA;</xsl:text>
    <xsl:text>TNav    = T.Nav.     = Ttulo de Navarra &#xD;&#xA;</xsl:text>
    <xsl:text>TPor    = T.Por.     = Ttulo de Portugal &#xD;&#xA;</xsl:text>
    <xsl:text>TRC     = T.R.C.     = Ttulo de los Reyes Catlicos &#xD;&#xA;</xsl:text>
    <xsl:text>TRCI    = T.R.C.Ind. = Ttulo de Indias (por los Reyes Catlicos) &#xD;&#xA;</xsl:text>
    <xsl:text>TDS     = T.D.S.     = Ttulo de las Dos Sicilias &#xD;&#xA;</xsl:text>
    <xsl:text>TSic    = T.Sic.     = Ttulo de Sicilia &#xD;&#xA;</xsl:text>
    <xsl:text>TSIR    = T.S.I.R.   = Ttulo del Sacro Imperio Romano &#xD;&#xA;</xsl:text>
    <xsl:text>TSM     = T.S.M.     = Ttulo de San Marino &#xD;&#xA;</xsl:text>
    <xsl:text>TSS     = T.S.S.     = Ttulo de la Santa Sede &#xD;&#xA;</xsl:text>
    <xsl:text>Tod     = T.o.d.     = Ttulo de origen desconocido &#xD;&#xA;</xsl:text>
	
    <xsl:text>Sces    = Suc.ces.  = Suceso de cesin (Ttulo/Dignidad/Grandeza cedido/a) &#xD;&#xA;</xsl:text>
	<xsl:text>Sinc    = Suc.inc.  = Suceso de incorporacin (Ttulo/Dignidad/Grandeza incorporado/a) &#xD;&#xA;</xsl:text>
	<xsl:text>Srec    = Suc.rec.  = Suceso de reconocimiento (Ttulo/Dignidad/Grandeza reconocido/a) &#xD;&#xA;</xsl:text>
    <xsl:text>Ssub    = Suc.sub.  = Suceso de subrogacin (Ttulo/Dignidad/Grandeza subrogado/a) &#xD;&#xA;</xsl:text>
	<xsl:text>Stra    = Suc.tra.  = Suceso de transferencia (Ttulo/Dignidad/Grandeza transferido/a) &#xD;&#xA;</xsl:text>

    <xsl:text>NN      = N.N.       = Nomen Nominandum &#xD;&#xA;</xsl:text>
    <xsl:text>desde   = dsd.       = (desde) &#xD;&#xA;</xsl:text>
    <xsl:text>hasta   = hst.       = (hasta) &#xD;&#xA;</xsl:text>
    <xsl:text>fecha   = fha.       = (fecha) &#xD;&#xA;</xsl:text>
    <xsl:text>dudoso  = dud.       = caso/dato/tipo en duda (origen/ttulo/nombre/... dudoso) &#xD;&#xA;</xsl:text>
    <xsl:text>feudal  = fdl.       = antiguo territorio/ttulo feudal &#xD;&#xA;</xsl:text>
    <xsl:text>legend  = leg.       = Fecha de creacin legendaria &#xD;&#xA;</xsl:text>
    <xsl:text>Cre     = cre.       = Fecha de creacin &#xD;&#xA;</xsl:text>
    <xsl:text>Acc     = acc.       = Fecha de accesin &#xD;&#xA;</xsl:text>
    <xsl:text>Suc     = suc.       = Fecha de sucesin &#xD;&#xA;</xsl:text>
    <xsl:text>Ces     = ces.       = Fecha de cesin, Ttulo/Dignidad/Grandeza cedido/a &#xD;&#xA;</xsl:text>
	<xsl:text>Inc     = inc.       = Fecha de incorporacin, Ttulo/Dignidad/Grandeza incorporado/a &#xD;&#xA;</xsl:text>
	<xsl:text>Rec     = rec.       = Fecha de reconocimiento, Ttulo/Dignidad/Grandeza reconocido/a &#xD;&#xA;</xsl:text>
    <xsl:text>Sub     = sub.       = Fecha de subrogacin, Ttulo/Dignidad/Grandeza subrogado/a &#xD;&#xA;</xsl:text>
	<xsl:text>Tra     = tra.       = Fecha de transferencia, Ttulo/Dignidad/Grandeza transferido/a &#xD;&#xA;</xsl:text>
    <xsl:text>Ocu     = ocu.       = Fecha de ocupacin (= acc./suc.), Ttulo ocupado/vigente &#xD;&#xA;</xsl:text>
    <xsl:text>Vac     = vac.       = Fecha de vacancia, Ttulo vacante (desde que da de la muerte de titular precedente) &#xD;&#xA;</xsl:text>
    <xsl:text>Can     = can.       = Fecha de cancelacin, Ttulo cancelado &#xD;&#xA;</xsl:text>
    <xsl:text>Ren     = ren.       = Fecha de renunciacin, Ttulo renunciado &#xD;&#xA;</xsl:text>
    <xsl:text>Anu     = anu.       = Fecha de anulacin, Ttulo anulado &#xD;&#xA;</xsl:text>
    <xsl:text>Cad     = cad.       = Fecha de caducidad, Ttulo caducado &#xD;&#xA;</xsl:text>
    <xsl:text>Sup     = sup.       = Fecha de supresin, Ttulo suprimido &#xD;&#xA;</xsl:text>
    <xsl:text>Rev     = rev.       = Fecha de reversin, Ttulo revertido &#xD;&#xA;</xsl:text>
    <xsl:text>Ext     = ext.       = Fecha de extincin, Ttulo extinguido &#xD;&#xA;</xsl:text>
    <xsl:text>*         nac.       = Fecha de nacimiento &#xD;&#xA;</xsl:text>
    <xsl:text>          cas.       = Fecha de casamiento &#xD;&#xA;</xsl:text>
    <xsl:text>         fal.       = Fecha de fallecimiento &#xD;&#xA;</xsl:text>
    <xsl:text>          lt.       = ltima fecha / ltimo nmero&#xD;&#xA;</xsl:text>
    <xsl:text>          ppal.      = principal (y su posicin) de ttulo(s) vinculado(s) &#xD;&#xA;</xsl:text>
    <xsl:text>          v.         = vase (posicin del) ttulo principal/vinculado &#xD;&#xA;</xsl:text>
	
    <xsl:text>GdE      = G.d.E.      = Grandeza de Espaa &#xD;&#xA;</xsl:text>
    <xsl:text>GdEPC    = G.d.E.cre.  = Grandeza de Espaa de primera creacin (1 clase y antigedad) &#xD;&#xA;</xsl:text>
    <xsl:text>GdE1a    = G.d.E.1    = Grandeza de Espaa de primera clase &#xD;&#xA;</xsl:text>
    <xsl:text>GdE2a    = G.d.E.2    = Grandeza de Espaa de segunda clase &#xD;&#xA;</xsl:text>
    <xsl:text>GdE3a    = G.d.E.3    = Grandeza de Espaa de tercera clase &#xD;&#xA;</xsl:text>
    <xsl:text>GdEHon   = G.d.E.hon.  = Grandeza de Espaa honoraria &#xD;&#xA;</xsl:text>
    <xsl:text>GdEVit   = G.d.E.vit.  = Grandeza de Espaa vitalicia &#xD;&#xA;</xsl:text>
    <xsl:text>GdEPers  = G.d.E.pers. = Grandeza de Espaa personal &#xD;&#xA;</xsl:text>

</xsl:template>

<!--  ================================================  -->
<!--  ================================================  -->
<!--  ================================================  -->

<xsl:variable name="SucesoGdEPC" select="'|Ducado.Lerma|Ducado.MedinaRioseco|Ducado.PenarandaDuero|Ducado.Osuna|Ducado.Infantado|Marquesado.Santillana|Marquesado.Cenete|Marquesado.Denia2|Condado.Melgar|Condado.MirandaCastanar|Condado.Urena2|'" />

<xsl:template name="Suceso4ID">
    <xsl:param name="ID" />
    <xsl:choose>
        <xsl:when test="$ID='Ducado.Lerma'"><xsl:text>[sub. de la G.za inicial (1.cre.) del M.do de Denia, </xsl:text><xsl:call-template name="Enlace4ID"><xsl:with-param name="ID" select="'Marquesado.Denia2'" /></xsl:call-template><xsl:text>] </xsl:text></xsl:when>
        <xsl:when test="$ID='Ducado.MedinaRioseco'"><xsl:text>[sub. de la G.za inicial (1.cre.) del C.do de Melgar, </xsl:text><xsl:call-template name="Enlace4ID"><xsl:with-param name="ID" select="'Condado.Melgar'" /></xsl:call-template><xsl:text>] </xsl:text></xsl:when>
        <xsl:when test="$ID='Ducado.PenarandaDuero'"><xsl:text>[sub. de la G.za inicial (1.cre.) del C.do de Miranda del Castaar, </xsl:text><xsl:call-template name="Enlace4ID"><xsl:with-param name="ID" select="'Condado.MirandaCastanar'" /></xsl:call-template><xsl:text>] </xsl:text></xsl:when>
        <xsl:when test="$ID='Ducado.Osuna'"><xsl:text>[sub. de la G.za inicial (1.cre.) del C.do de Urea, </xsl:text><xsl:call-template name="Enlace4ID"><xsl:with-param name="ID" select="'Condado.Urena2'" /></xsl:call-template><xsl:text>] </xsl:text></xsl:when>
        <xsl:when test="$ID='Ducado.Infantado'"><xsl:text>[inc. de la G.za inicial (1.cre.) del M.do del Cenete, </xsl:text><xsl:call-template name="Enlace4ID"><xsl:with-param name="ID" select="'Marquesado.Cenete'" /></xsl:call-template><xsl:text>] </xsl:text></xsl:when>
        <xsl:when test="$ID='Marquesado.Santillana'"><xsl:text>[rec. de la G.d.E. inmemorial equiv. a la G.za de 1.cre.] </xsl:text></xsl:when>
        <xsl:when test="$ID='Marquesado.Cenete'"><xsl:text>[tra. de la G.za inicial (1.cre.) al D.do del Infantado, </xsl:text><xsl:call-template name="Enlace4ID"><xsl:with-param name="ID" select="'Ducado.Infantado'" /></xsl:call-template><xsl:text>] </xsl:text></xsl:when>
        <xsl:when test="$ID='Marquesado.Denia2'"><xsl:text>[ces. de la G.za inicial (1.cre.) por sub. al D.do de Lerma, </xsl:text><xsl:call-template name="Enlace4ID"><xsl:with-param name="ID" select="'Ducado.Lerma'" /></xsl:call-template><xsl:text>] </xsl:text></xsl:when>
        <xsl:when test="$ID='Condado.Melgar'"><xsl:text>[ces. de la G.za inicial (1.cre.) por sub. al D.do de Medina de Roseco, </xsl:text><xsl:call-template name="Enlace4ID"><xsl:with-param name="ID" select="'Ducado.MedinaRioseco'" /></xsl:call-template><xsl:text>] </xsl:text></xsl:when>
        <xsl:when test="$ID='Condado.MirandaCastanar'"><xsl:text>[ces. de la G.za inicial (1.cre.) al D.do de Pearanda de Duero, </xsl:text><xsl:call-template name="Enlace4ID"><xsl:with-param name="ID" select="'Ducado.PenarandaDuero'" /></xsl:call-template><xsl:text>] </xsl:text></xsl:when>
        <xsl:when test="$ID='Condado.Urena2'"><xsl:text>[ces. de la G.za inicial (1.cre.) al D.do de Osuna, </xsl:text><xsl:call-template name="Enlace4ID"><xsl:with-param name="ID" select="'Ducado.Osuna'" /></xsl:call-template><xsl:text>] </xsl:text></xsl:when>
    </xsl:choose>
</xsl:template>

<xsl:template name="Enlace4ID"> <!-- 0000|Clase.Denom| -->
    <xsl:param name="ID" />
	<xsl:value-of select="concat(format-number(count(key('NobilXMLID',$ID)/preceding-sibling::adhoc:item)+1,'0000'),'|',$ID,'|')" />
</xsl:template>

<!--  ================================================  -->
<!--  ================================================  -->
<!--  ================================================  -->

</xsl:stylesheet>

<!--  ================================================  -->
<!--  EOF                                               -->
<!--  ================================================  -->