#
# usage: ... | sed -f Nobiliario.sed > Nobiliario.xml
# should be GNU-sed (gsed) or super-sed (ssed) 
# cf http://sed.sf.net/grabbag/ssed/   
#	 http://unxutils.sf.net/   
#    http://gnuwin32.sf.net/
#
# #############################################################################
#
# search: date-elements w/o ISO-attribute, <date><y>YYYY</y><m>[M]M</m><d>[D]D</d></date>
# insert: attribute ISO="YYYY-MM-DD", leading zeros if necessary, single "?"s doubled
# norm: ISO 8601:2004 Representation of dates and times, EN 28601:1992, cf http://www.w3.org/TR/NOTE-datetime
#
/<date>/{
	s/<date><y>\(.\{1,4\}\)<\/y><m>\(.\{1,2\}\)<\/m><d>\(.\{1,2\}\)<\/d>/<date ISO="\1-\2-\3"><y>\1<\/y><m>\2<\/m><d>\3<\/d>/
	s/<to *\/><y>\(.\{1,4\}\)<\/y><m>\(.\{1,2\}\)<\/m><d>\(.\{1,2\}\)<\/d>/<to ISO="\1-\2-\3"\/><y>\1<\/y><m>\2<\/m><d>\3<\/d>/
#	s/"\([1-9]\{1\}\)-/"0\1-/
#	s/"\([0-9]\{2\}\)-/"0\1-/
	s/"\([0-9]\{3\}\)-/"0\1-/g
	s/-\([1-9]\)-/-0\1-/g
	s/-\([1-9]\)"/-0\1"/g
	s/-?/-??/g
}
#
# #############################################################################
#
# insert a sorting-hint into surnames (apellido-elements)
# <SOM/> precedes the first capital letter: sort name after hint, ignore surname-particles before hint
# <SOM/> = Sort Order Mark, SOrt Mark 
# &#xA0; = Nonbreaking Space, may prevent loss of whitespace by normalisation
#
/<n:Apellido>[[:lower:]]/{
	/<SOM\/>/!{
		s/ \([[:upper:]]\)/ <SOM\/>\1/
	}
}
#
# POSIX character class [[:lower:]] vs [a-z]
# POSIX character class [[:upper:]] vs [A-Z]
#
# #############################################################################
#
# insert a gender-token (mujer/varn) into n:Nobleza's xhtml:class-attribute
#
/<n:Nobleza /{
	s/a TM[ae][yn]or/& Mujer/
	t TMayor
	s/ TM[ae][yn]or/& Varon/
	t TMayor
}
#
# #############################################################################
#
# insert a PconV/PsinV/VconV token into n:Nobleza's xhtml:class-attribute
#
:TMayor
/TMayor/{
	s/" xhtml:title="N01"/ PsinV&/
	t TMenor
	s/" xhtml:title="/ PconV&/
	t TMenor
}
:TMenor
/TMenor/{
	s/" xhtml:title="/ VconV&/
	t
}
#
# #############################################################################
#
# prepare adjusted number statistics for n:Reinado
#
/<n:Reinado /{
	s/_0/__/g
	s/_0/__/g
}
#
# #############################################################################
#
# indent transformation-result from msxsl
#
/^<\/\{0,1\}n:Titulo/s/^/\t/
	/^<n:Numero/s/^/\t\t/
    /^<n:Clase/s/^/\t\t/
    /^<n:Parte/s/^/\t\t/
    /^<n:Denominacion/s/^/\t\t/
/^<\/\{0,1\}n:Creacion/s/^/\t/
/^<\/\{0,1\}n:Grandeza/s/^/\t/
/^<\/\{0,1\}n:Sucesion/s/^/\t/
	/^<n:Instrumento/s/^/\t\t/
/^<\/\{0,1\}n:Titular/s/^/\t/
    /^<\/\{0,1\}n:Nombre/s/^/\t\t/
        /^<n:Cortesia/s/^/\t\t\t/
        /^<n:dePila/s/^/\t\t\t/
        /^<n:Apellido/s/^/\t\t\t/
    /^<n:Nacimiento/s/^/\t\t/
/^<n:Fecha/s/^/\t/
/^<n:Nota/s/^/\t/
#
# #############################################################################
#
# write Nobleza-TT.xml's LOGs (logged in Nobiliario.xml) to Nobleza-TT.log
# ".LOG" at end of line is begin of block (excluded)
# ".LOG" at begin of line is end of block (excluded)
#
/\.LOG$/,/^\.LOG/{
    /\.LOG$/b
    /^\.LOG/b
    h
    y/ܟ/yaeiouaeiouaeiouanoaeiouyYAEIOUAEIOUAEIOUANOAEIOUYcC/
    w Nobleza-TT.log
    g
}
#