
// -----------------------------------------------------------------
// date time &c
// -----------------------------------------------------------------

if ( !Date.prototype.toISOString ) {
    ( function() {
		function pad(n) { return (n<10?'0':'')+n ; }
        Date.prototype.toISOString = function() {
            return this.getUTCFullYear()
                + '-' + pad( this.getUTCMonth()+1 )
                + '-' + pad( this.getUTCDate() )
                + 'T' + pad( this.getUTCHours() )
                + ':' + pad( this.getUTCMinutes() )
                + ':' + pad( this.getUTCSeconds() )
                + '.' + String( (this.getUTCMilliseconds()/1000).toFixed(3) ).slice(2,5)
                + 'Z';
        };
    }() );
}

if ( !Date.prototype.toISOStringTZ ) { // ISO of local TimeZone (hh:mm to UTC)
    ( function() {
		function pad(n) { return (n<10?'0':'')+n ; }
		function tzd(n) { return (n<0?'+':'-')+pad(Math.abs(0|(n/60)))+':'+pad(Math.abs(n%60)); } 
        Date.prototype.toISOStringTZ = function() {
			var tzo  = this.getTimezoneOffset(); 
			return   [ this.getFullYear(),
				'-' , pad( this.getMonth()+1 ),
				'-' , pad( this.getDate() ),
				'T' , pad( this.getHours() ),
				':' , pad( this.getMinutes() ),
				':' , pad( this.getSeconds() ),
				// '.' , String( (this.getMilliseconds()/1000).toFixed(3) ).slice(2,5),
				((tzo) ? tzd(tzo) : 'Z' ) 
			].join('');
        };
    }() );
}

// -----------------------------------------------------------------

var baseDate = new Date();
var baseDays = Math.floor(baseDate.valueOf()/86400000);
var modiDate = new Date(document.lastModified);
var modiDays = baseDays-(Math.floor(modiDate.valueOf()/86400000));
var ISO4Date = /(\d{4}-\d{2}-\d{2})/;   //  /([0-9]{4}-[0-9]{2}-[0-9]{2})/  /(\d{4}-\d{2}-\d{2})/  /(\d\d\d\d-\d\d-\d\d)/
var base2Day = { "y":baseDate.getUTCFullYear(),"m":baseDate.getUTCMonth()+1,"d":baseDate.getUTCDate() }
    base2Day.YY  = ''+base2Day.y;
    base2Day.MM  = ((base2Day.m<10)?'0':'')+base2Day.m;
    base2Day.DD  = ((base2Day.d<10)?'0':'')+base2Day.d;
    base2Day.ISO = base2Day.YY+'-'+base2Day.MM+'-'+base2Day.DD;

function getDays2Date(oDate) { // Arg: Object Date
    return Math.abs(baseDays-(Math.floor(oDate.valueOf()/86400000)));
} // END:fn
function getDaysSince(strYYYY,strMM,strDD) { // StrOfMonths: [0]1-12
    return Math.abs(baseDays-(Math.floor(Date.UTC(parseInt(strYYYY,10),parseInt(strMM,10)-1,parseInt(strDD,10))/86400000)));
} // END:fn
function getDuration(fromISODate,toISODate) { // Args: String ISO-Date = "YYYY-MM-DD"
    var fromDate = fromISODate.split('-');    var toDate = toISODate.split('-');
    return getDaysSince(toDate[0],toDate[1],toDate[2])-getDaysSince(fromDate[0],fromDate[1],fromDate[2]);
} // END:fn
function getDuration2Day(fromISODate) { // Arg: String ISO-Date = "YYYY-MM-DD"
    var fromDate = fromISODate.split('-');
    return getDaysSince(fromDate[0],fromDate[1],fromDate[2]);
} // END:fn

DaysOfMonthInYear = function(MM,YY){ return (MM==2) ? (((!(YY%4) && (YY%100)) || !(YY%400)) ? 29 : 28) : [0,31,28,31,30,31,30,31,31,30,31,30,31][MM] ; }

function FromDate2Date(fDate,tDate) { // Args: Object Date
    return getDaysAsAMD(Math.abs((Math.floor(tDate.valueOf()/86400000))-(Math.floor(fDate.valueOf()/86400000))));
}
function FromToISODate(fISODate,tISODate) { // Args: String ISO-Date = "YYYY-MM-DD"
    var fDate = fISODate.split('-');
    var tDate = tISODate.split('-');
    return FromToNumDate(parseInt(fDate[0],10),parseInt(fDate[1],10),parseInt(fDate[2],10),parseInt(tDate[0],10),parseInt(tDate[1],10),parseInt(tDate[2],10));
}
function FromToISO2Day(fISODate) { // Arg: String ISO-Date = "YYYY-MM-DD"
    var fDate = fISODate.split('-');
    return FromToNumDate(parseInt(fDate[0],10),parseInt(fDate[1],10),parseInt(fDate[2],10),base2Day.y,base2Day.m,base2Day.d);
}
function FromToNumDate(fY,fM,fD,tY,tM,tD) { // NumOfMonths: 1-12
    var rY=tY-fY; var rM=tM-fM; var rD=tD-fD;
    if (rD<0) { rD+=DaysOfMonthInYear(fM,fY); rM--; }
    if (rM<0) { rM+=12; rY--; }
    // return ((rY)?((rY<10)?"0":"")+rY+"a ":"")+((rM)?((rM<10)?"0":"")+rM+"m ":"")+((rD)?((rD<10)?"0":"")+rD+"d":"");
    return ((rY)?rY+"a ":"")+((rM)?rM+"m ":"")+((rD)?rD+"d":"");
}
function FromToStrDate(fY,fM,fD,tY,tM,tD) { // StrOfMonths: [0]1-12
    var rY=parseInt(tY,10)-parseInt(fY,10);
    var rM=parseInt(tM,10)-parseInt(fM,10);
    var rD=parseInt(tD,10)-parseInt(fD,10);
    if (rD<0) { rD+=DaysOfMonthInYear(fM,fY); rM--; }
    if (rM<0) { rM+=12; rY--; }
    // return ((rY)?((rY<10)?"0":"")+rY+"a ":"")+((rM)?((rM<10)?"0":"")+rM+"m ":"")+((rD)?((rD<10)?"0":"")+rD+"d":"");
    return ((rY)?rY+"a ":"")+((rM)?rM+"m ":"")+((rD)?rD+"d":"");
}
function FromZoff2Zadd(TZoff) { // Arg: NumOfMinutes mmm e.g. aDateObj.getTimezoneOffset() 
	return (TZoff<0?"+":"-")+(Math.abs(0|(TZoff/60))+":"+Math.abs(TZoff%60)).replace(/\b(\d)\b/g,'0$1');
} // Ret:  reversed sign ISO-TZD to UCT = hh:mm

function Date2ISO(DateObj /* +none|false|true */ ) { // true = localTimeZone, none = false = default = UTC
	this.Date =  (DateObj instanceof Date) ? DateObj : new Date() ;
	
	this.ISOfull = (arguments[1]===true) ? this.Date.toISOStringTZ() : this.Date.toISOString() ;
	this.ISOextY = (       /^([-+]\d{2})\d{4}/.test(this.ISOfull)) ? RegExp.$1 : "+00"         ;
	this.ISOdate = (     /(\d{4}-\d{2}-\d{2})/.test(this.ISOfull)) ? RegExp.$1 : "????-??-??"  ; // this.ISOfull.substr(0,10);
	this.ISOtime = (    /T(\d{2}:\d{2}:\d{2})/.test(this.ISOfull)) ? RegExp.$1 : "??:??:??"    ; // this.ISOfull.substr(11,8);
	this.ISOfrac = (               /[.,](\d+)/.test(this.ISOfull)) ? RegExp.$1 : "???"         ;
	this.ISOzone = (/(Z|(?:[-+]\d{2}:\d{2}))$/.test(this.ISOfull)) ? RegExp.$1 : "\u00B1??:??" ;
	
	this.UTCzoff = this.Date.getTimezoneOffset();
    this.UTCzadd = (this.UTCzoff) ? (this.UTCzoff<0?"+":"-")+(Math.abs(0|(this.UTCzoff/60))+":"+Math.abs(this.UTCzoff%60)).replace(/\b(\d)\b/g,'0$1') : "" ;
	
	return this;
}

var modifISO = new Date2ISO(modiDate);  
var modi2Day = FromToNumDate(modiDate.getUTCFullYear(),modiDate.getUTCMonth()+1,modiDate.getUTCDate(),baseDate.getUTCFullYear(),baseDate.getUTCMonth()+1,baseDate.getUTCDate());
var reviData = '<b>'+modifISO.ISOdate+'<\/b> '+modifISO.ISOtime.substr(0,5)+' UTC ('+modifISO.UTCzadd+'=LT)'+((modi2Day)?' ~ '+modi2Day:'');

// -----------------------------------------------------------------
// [May 1, 2012: Durations (years-months-days (ao-mes-da) till today) computed from clear Dates]
// -----------------------------------------------------------------

function calcDateRanges() {
var dateElems = NobListPre.getElementsByTagName("b");
	for (var i=0; i<dateElems.length; i++)
	{
	if (ISO4Date.test(dateElems[i].firstChild.data)) dateElems[i].firstChild.appendData(" ("+FromToISO2Day(RegExp.$1)+")") ;
	}
}

// -----------------------------------------------------------------
//
// -----------------------------------------------------------------

var NobListPre = document.getElementById("NobList");
var NobCloneTT = [];

function saveNobItems() 
{
	var NobItemsTT = NobListPre.getElementsByTagName("tt");
	for (var li=0; li<NobItemsTT.length; li++) 
	{
		Nob.OrdenSuces[li] = li;
		Nob.OrdenVerso[li] = Nob.ITEMS-1-li;
		NobCloneTT[li] = NobItemsTT[li].cloneNode(true);
	}
}

function listNobItems(ordToken) 
{
	with (NobListPre) { while (hasChildNodes()) { void(removeChild(lastChild)); } };
	for (var li=0; li<NobCloneTT.length; li++) 
	{
		NobListPre.appendChild(NobCloneTT[Nob[ordToken][li]]);
	}
	hashIntoView(XPtrId2FragId(window.location.hash||window.location.search));
}

// -----------------------------------------------------------------
// [2013-03: make <http://en.wikipedia.org/wiki/Fragment_identifier> work]
// -----------------------------------------------------------------
//~ http://www.w3.org/TR/cuap#uri
//~ http://www.w3.org/QA/2011/05/hash_uris.html
//~ http://www.w3.org/TR/NOTE-xptr-req
//~ http://www.w3.org/TR/xptr-framework/
//~ http://www.w3.org/TR/xptr-xpointer/
//~ http://www.w3.org/TR/xptr-element/
//~ http://www.w3.org/TR/xptr-xmlns/
// -----------------------------------------------------------------

var IdRefStyle = {
	"FragID"      : { "pfx":"#" , "ifx":"", "sfx":"" } ,
	"QueryID"     : { "pfx":"?" , "ifx":"", "sfx":"" } ,
	"FragIdID"    : { "pfx":"#" , "ifx":"id=", "sfx":"" } ,
	"QueryIdID"   : { "pfx":"?" , "ifx":"id=", "sfx":"" } ,
	"FragXPtrID"  : { "pfx":"#" , "ifx":"xpointer(id('", "sfx":"'))" } ,
	"QueryXPtrID" : { "pfx":"?" , "ifx":"xpointer(id('", "sfx":"'))" }
};

function link2IdRefStyle(sty) {
sty = (sty in IdRefStyle) ? IdRefStyle[sty] : IdRefStyle["FragID"] ;
var NobLinksTT = NobListPre.getElementsByTagName("a");
	if (Array.prototype.forEach)
	{
	Array.prototype.forEach.call(NobLinksTT,function(e){ e.href=sty.pfx+sty.ifx+(e.id||e.href.split("#").pop())+sty.sfx; });
	} else {
	for (var li=0; li<NobLinksTT.length; li++) NobLinksTT[li].href=sty.pfx+sty.ifx+(NobLinksTT[li].id||NobLinksTT[li].href.split("#").pop())+sty.sfx; 
	}
}

function hashIntoView(IdRef) // <http://www.w3.org/TR/cssom-view/#dom-element-scrollintoview>
{
	var ElRef = (IdRef) ? document.getElementById(IdRef) : false ;
	if (ElRef && ElRef.scrollIntoView) ElRef.scrollIntoView();
}
function nameIntoView(IdRef) 
{
	var ElRef = (IdRef) ? document.getElementsByName(IdRef) : false ;
	if (ElRef && ElRef.length && ElRef[0].scrollIntoView) ElRef[0].scrollIntoView();
}
function XPtrId2FragId(Frag) // extract restricted ID-subset of XML-ID-NCName from (ID|xpointer(id('ID'))|id=ID)
{
	return (/[?&#](?:id=|xpointer\(id\(['"])?([A-Za-z]\w+\.\w+)(?:['"]\)\))?/i.test(Frag)) ? RegExp.$1 : "" ;
}

// -----------------------------------------------------------------
//
// -----------------------------------------------------------------

function getAttributeDOMx(el,ns,pfx,name) {
    if (el.getAttributeNS) { return el.getAttributeNS(ns,name); }
    else { return el.getAttribute(name)||el.getAttribute(pfx+":"+name); }
} // END:fn
function setAttributeDOMx(el,ns,qname,val) {
    if (el.setAttributeNS) { return el.setAttributeNS(ns,qname,val); }
    else { return el.setAttribute(qname,val); }
} // END:fn

// -----------------------------------------------------------------
//
// -----------------------------------------------------------------

window.onload=function()
{ 
	// [2013-03-03: xml:base="http://unterstein.net/NobEsp?action=view&view=TitulosPLANO"]
	//
	// void(setAttributeDOMx(NobListPre,"http:\/\/www.w3.org\/XML\/1998\/namespace","xml:base",((window.location.protocol=="http:")?"http:\/\/unterstein.net\/or\/":"")+"Nobiliario.html?action=view\u0026view=TitulosPLANO"));
	//
	// link2IdRefStyle("FragXPtrID");
	//
	calcDateRanges(); saveNobItems(); 
	document.forms["NobForm"].elements["NobOrdToken"].disabled=false;
	document.forms["NobForm"].elements["NobOrdInput"].disabled=false;
	document.forms["NobForm"].elements["NobIDsInput"].onclick=function() { hashIntoView(XPtrId2FragId(window.location.hash||window.location.search)); return false; }
	document.forms["NobForm"].elements["NobIDsInput"].disabled=false;
	var NUA=document.getElementById("NobUltAct");
		NUA.className=""; // remove load-indicator (throbber)
		NUA.removeAttribute(/*@if (@_jscript_version < 5.8) "className" @else @*/ "class" /*@end @*/); 
		NUA.title="ltima actualizacin\/revisin de la pgina (UTC=GMT)";
		NUA.innerHTML="lt.act."+reviData;
	hashIntoView(XPtrId2FragId(window.location.hash||window.location.search));
}
