<?xml version="1.0" encoding="iso-8859-1"?>
<!DOCTYPE xsl:stylesheet
          [
          <!ENTITY dt "<![CDATA[
            var baseDate = new Date();
            var base2Day = { 'y':baseDate.getUTCFullYear(),'m':baseDate.getUTCMonth()+1,'d':baseDate.getUTCDate() };
                base2Day.YY  = ''+base2Day.y;
                base2Day.MM  = ((base2Day.m<10)?'0':'')+base2Day.m;
                base2Day.DD  = ((base2Day.d<10)?'0':'')+base2Day.d;
                base2Day.ISO = base2Day.YY+'-'+base2Day.MM+'-'+base2Day.DD;
            var global = this;
            this['date'] = function() { return base2Day.ISO; }
            this['gGet'] = function(NN) { return global[NN]; }
            this['gSet'] = function(NN,Val) { return global[NN] = Val; }
          ]]>">
          <!ENTITY eu "<![CDATA[
			var xcharX = '89AB89ab01234567cdef01234567CDEF'.split(''); // 31 random() per UUID, miXed case
			var uuid4X = function() { 
				return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function($0){ return xcharX[0|Math.random()*{'x':32,'y':8}[$0]]; }); 
				}
			var uuid4x = function() { 
				return ('xxxxxxxx-xxxx-4xxx-'+xcharX[0|Math.random()*8]+'xxx-xxxxxxxxxxxx').replace(/x/g, function(){ return xcharX[0|Math.random()*32]; }); 
				}
            this['uuid'] = function() { return uuid4x(); }
          ]]>">
          ]>
<!--  ================================================  -->
<!--  ================================================  -->
<!--  ================================================

        msxsl Nobleza-TT.xml Nobleza-TT.xsl -xw -t -o Nobiliario.xml NN=mergeTT
        msxsl Nobleza-TT.xml Nobleza-TT.xsl -xw -t NN=mergeTT | ssed -f Nobiliario.sed > Nobiliario.xml
        msxsl Nobleza-TT.xml Nobleza-TT.xsl -xw -t NN=mergeTT | ssed -f Nobiliario.sed | bzip2 -9cvv > Nobiliario.xml.bz2
        msxsl Nobleza-TT.xml Nobleza-TT.xsl -xw    NN=statsTT
        msxsl Nobiliario.xml Nobleza-TT.xsl -xw -t -o Nobleza-TT.xml NN=splitTT
        msxsl Nobiliario.xml Nobleza-TT.xsl -xw -t NN=splitTT | ssed -f Nobleza-TT.sed > Nobleza-TT.xml

      ================================================  -->
<!--  ================================================  -->
<!--  ================================================  -->

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xhtml="http://www.w3.org/1999/xhtml"
                xmlns:xlink="http://www.w3.org/1999/xlink"
                xmlns:adhoc="urn:xmlns:adhoc"
                xmlns:n="urn:xmlns:Nobiliario"
                xmlns:efunc="http://exslt.org/functions"
                xmlns:edate="http://exslt.org/dates-and-times"
                xmlns:euser="urn:xmlns:extension-by-user"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                extension-element-prefixes="msxsl efunc edate euser"
                exclude-result-prefixes="msxsl efunc edate euser adhoc"
                >
<xsl:output method="xml"
            indent="yes"
            media-type="application/xml"
            doctype-system="Nobiliario.dtd"
            encoding="iso-8859-1" />

<xsl:variable name="GnomeXmlSoft" select="system-property('xsl:vendor')='libxml'" />
<xsl:variable name="TransforMiiX" select="system-property('xsl:vendor')='Transformiix'" />
<xsl:variable name="MicrosoftXML" select="system-property('xsl:vendor')='Microsoft'" />
<xsl:variable name="GingerSablot" select="system-property('xsl:vendor')='Ginger Alliance'" />
<xsl:variable name="OperaExpat"   select="system-property('xsl:vendor')='Opera'" />
<xsl:variable name="UnicornUXT"   select="contains(system-property('xsl:vendor'),'Unicorn')" />
<xsl:variable name="AltovaXSLT"   select="contains(system-property('xsl:vendor'),'Altova')" />
<xsl:variable name="InstantSAXON" select="contains(system-property('xsl:vendor'),'SAXON')" />

<!--  ================================================  -->
<!--  ================================================  -->
<!--  ================================================  -->

<xsl:param name="NN" select="''" /> <!-- mergeTT splitTT -->

<efunc:script language="javascript" implements-prefix="edate">&dt;</efunc:script>
<efunc:script language="javascript" implements-prefix="euser">&eu;</efunc:script>
<msxsl:script language="javascript" implements-prefix="edate">&dt;</msxsl:script>
<msxsl:script language="javascript" implements-prefix="euser">&eu;</msxsl:script>

<xsl:param name="MakeDate">
<xsl:choose>
    <xsl:when test="function-available('edate:date')">
        <xsl:value-of select="substring(edate:date(),'1','10')" />
    </xsl:when>
    <xsl:otherwise>
        <xsl:text>????-??-??</xsl:text>
        <xsl:message>[exslt|msxsl]:script extension/functions not supported !?</xsl:message>
    </xsl:otherwise>
</xsl:choose>
</xsl:param>
<xsl:param name="MakeUUID" />
<xsl:variable name="BoolUUID">
<xsl:choose>
    <xsl:when test="boolean($MakeUUID) and function-available('euser:uuid')">
        <xsl:value-of select="true()" />
    </xsl:when>
    <xsl:otherwise>
        <xsl:value-of select="false()" />
    </xsl:otherwise>
</xsl:choose>
</xsl:variable>

<!--  ================================================  -->
<!--  ================================================  -->
<!--  ================================================  -->

<xsl:key name="NobilXMLID" match="//adhoc:list[1]/adhoc:item" use=".//n:Nobleza/@xml:id" />
<xsl:key name="NobilXLINK" match="//adhoc:list[1]/adhoc:item" use="substring-after(.//n:Nobleza/n:Nota/n:vease/@xlink:href,'#')" />

<xsl:key name="TitulXMLID" match="//n:Titulo" use="@xml:id" />
<xsl:key name="TitulCLSID" match="//n:Titulo" use="substring-before(@xml:id,'.')" />
<xsl:key name="TitulXLINK" match="//n:Titular" use="./n:Sucesion/@xhtml:rel" />
<xsl:key name="SucesCLASS" match="//n:Sucesion" use="substring-before(@xhtml:class,' TM')" />
<xsl:key name="SucesXLINK" match="//n:Sucesion" use="@xhtml:rel" />
<xsl:key name="OrigenRdoID" match="//n:Reinado"  use="@xml:id" />
<xsl:key name="OrigenCreID" match="//n:Creacion" use="@xhtml:rel" />
<xsl:key name="OrigenGdEID" match="//n:Grandeza" use="@xhtml:rel" />

<xsl:key name="SucesoCreID" match="//n:Titulo[@xml:id=../n:Titular/n:Sucesion/@xhtml:rel]" use="./n:Creacion/@xhtml:rel" />
<xsl:variable name="SucesoGdEPC" select="'|Ducado.Lerma|Ducado.MedinaRioseco|Ducado.PenarandaDuero|Ducado.Osuna|Ducado.Infantado|Marquesado.Santillana|Marquesado.Cenete|Marquesado.Denia2|Condado.Melgar|Condado.MirandaCastanar|Condado.Urena2|'" />

<xsl:decimal-format name="zeroY" NaN="0000" />
<xsl:decimal-format name="zeroM" NaN="00" />
<xsl:decimal-format name="zeroD" NaN="00" />
<xsl:decimal-format name="QMark" NaN="?" />
<xsl:decimal-format name="nineY" NaN="9999" />
<xsl:decimal-format name="nineM" NaN="99" />
<xsl:decimal-format name="nineD" NaN="99" />


<!--  ================================================  -->
<!--  ================================================  -->
<!--  ================================================


      ================================================  -->
<!--  ================================================  -->
<!--  ================================================  -->

<xsl:template match="/">
    <xsl:choose>
        <xsl:when test="$NN='mergeTT'">
            <xsl:call-template name="mergeTT" />
        </xsl:when>
        <xsl:when test="$NN='splitTT'">
            <xsl:call-template name="splitTT" />
        </xsl:when>
        <xsl:when test="$NN='statsTT'">
            <xsl:comment>  ================================================  </xsl:comment>
            <xsl:comment>  ================================================ .LOG&#xD;&#xA;<xsl:call-template name="statsTT" />.LOG  ================================================  </xsl:comment>
            <xsl:comment>  ================================================  </xsl:comment>
        </xsl:when>
        <xsl:otherwise>
            <xsl:apply-templates />
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<!--  ================================================  -->
<!--  ================================================  -->
<!--  ================================================  -->

<xsl:template name="mergeTT">

    <xsl:processing-instruction name="xml-stylesheet"><xsl:text>type="text/css" href="Nobiliario.xml.css" title="StUs (Nobiliario)"</xsl:text></xsl:processing-instruction>
    <xsl:processing-instruction name="xml-stylesheet"><xsl:text>type="text/css" href="Nobiliario.ORo.css" title="ORo (Nobiliario)" alternate="yes"</xsl:text></xsl:processing-instruction>

    <xsl:comment>  ================================================  </xsl:comment>
    <xsl:comment>  ================================================

      Copyright (c) <xsl:value-of select="substring-before($MakeDate,'-')" /> ff. O.Rost  [Creation 2006-Mar-04]  cf. Nobiliario.rdf

      Project ID: NobiliarioEspanol
      Generic URI: http://www.unterstein.net/NobiliarioEspanol
      License: Creative Commons Attribution-NonCommercial-ShareAlike License [by-nc-sa]
      License URI: http://creativecommons.org/licenses/by-nc-sa/4.0/

      Description:

      Nobiliario de todos los ttulos espaoles en orden cronolgico de sucesin de los titulares
               y de otros ttulos en orden cronolgico de situaciones no ocupados (vacante, cancelado, renunciado, anulado, caducado, suprimido, revertido o extinguido)

      ================================================  </xsl:comment>
    <xsl:comment>  ================================================  </xsl:comment>

    <AdHocDoc xmlns="urn:xmlns:adhoc" dateModified="{$MakeDate}">
        <xhtml:title>or &#x00B7; Nobiliario Espaol (XML)</xhtml:title>
        <meta xlink:title="Creative Commons License + Dublin Core Metadata" xlink:type="resource" xlink:show="embed" xlink:actuate="onLoad" xlink:href="Nobiliario.rdf" />
    <n:NobiliarioEspanol xml:lang="es">

    <xsl:comment>  ================================================  </xsl:comment>
    <xsl:comment>  ================================================ .LOG&#xD;&#xA;<xsl:call-template name="statsTT" />.LOG  ================================================  </xsl:comment>
    <xsl:comment>  ================================================  </xsl:comment>
    <xsl:text>&#xD;&#xA;&#xD;&#xA;</xsl:text>

    <list>
    <xsl:for-each select="//n:Titular/n:Sucesion[@xhtml:rel!='']">
        <xsl:sort select="number(concat(format-number(./n:Instrumento[1]/adhoc:date/adhoc:y,'0000','nineY'),format-number(./n:Instrumento[1]/adhoc:date/adhoc:m,'00','nineM'),format-number(./n:Instrumento[1]/adhoc:date/adhoc:d,'00','nineD')))" data-type="number" order="ascending" />
        <xsl:variable name="TitulIDREF" select="@xhtml:rel" />
        <xsl:variable name="TitulIDKEY" select="key('TitulXMLID',$TitulIDREF)" />
        <xsl:variable name="TitulMujer" select="boolean(contains(@xhtml:class,'a TM'))" />
        <xsl:variable name="TitulClase">
            <xsl:call-template name="Class2Clase">
                <xsl:with-param name="C2C" select="@xhtml:class" />
            </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="ClaseIDPFX">
            <xsl:call-template name="Class2IdPfx">
                <xsl:with-param name="C2I" select="@xhtml:class" />
            </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="NofSuccessions" select="count(key('SucesXLINK',$TitulIDREF))" />
        <xsl:variable name="NofMajorTitles" select="count(../n:Sucesion[contains(@xhtml:class,'TMayor')])" />

        <xsl:if test="not($TitulIDKEY)">
            <xsl:text>&#xD;&#xA;</xsl:text>
            <xsl:comment> .LOG&#xD;&#xA;ERROR: non-existing title/IDREF (<xsl:value-of select="$TitulIDREF" />) ignored&#xD;&#xA;.LOG </xsl:comment>
            <xsl:text>&#xD;&#xA;</xsl:text>
        </xsl:if>
        <xsl:if test="count($TitulIDKEY)&gt;1">
            <xsl:text>&#xD;&#xA;</xsl:text>
            <xsl:comment> .LOG&#xD;&#xA;ERROR: non-unique title/IDREF (<xsl:value-of select="$TitulIDREF" />) ignored&#xD;&#xA;.LOG </xsl:comment>
            <xsl:text>&#xD;&#xA;</xsl:text>
        </xsl:if>
        <xsl:if test="$NofSuccessions&gt;1">
            <xsl:text>&#xD;&#xA;</xsl:text>
            <xsl:comment> .LOG&#xD;&#xA;ERROR: title w/ multiple references/successions (<xsl:value-of select="$TitulIDREF" />) ignored&#xD;&#xA;.LOG </xsl:comment>
            <xsl:text>&#xD;&#xA;</xsl:text>
        </xsl:if>
        <xsl:if test="$NofMajorTitles=0">
            <xsl:text>&#xD;&#xA;</xsl:text>
            <xsl:comment> .LOG&#xD;&#xA;ERROR: title/holder w/o major-title (<xsl:value-of select="$TitulIDREF" />) ignored&#xD;&#xA;.LOG </xsl:comment>
            <xsl:text>&#xD;&#xA;</xsl:text>
        </xsl:if>
        <xsl:if test="$NofMajorTitles&gt;1">
            <xsl:text>&#xD;&#xA;</xsl:text>
            <xsl:comment> .LOG&#xD;&#xA;ERROR: title/holder w/ multiple major-titles (<xsl:value-of select="$TitulIDREF" />) ignored&#xD;&#xA;.LOG </xsl:comment>
            <xsl:text>&#xD;&#xA;</xsl:text>
        </xsl:if>
        <!--
        <xsl:if test="substring-before($TitulIDREF,'.')!=key('ClaseTONES',substring-before(@xhtml:class,' TM'))/@token">
        <xsl:if test="substring-before($TitulIDREF,'.')!=document('')//adhoc:data[@tone=substring-before(@xhtml:class,' TM')]/@token">
          -->
        <xsl:if test="substring-before($TitulIDREF,'.')!=$ClaseIDPFX">
            <xsl:text>&#xD;&#xA;</xsl:text>
            <xsl:comment> .LOG&#xD;&#xA;ERROR: IDREF-prefix (<xsl:value-of select="$TitulIDREF" />) does not match CLASS-token (<xsl:value-of select="substring-before(@xhtml:class,' TM')" />)&#xD;&#xA;.LOG </xsl:comment>
            <xsl:text>&#xD;&#xA;</xsl:text>
        </xsl:if>
        <xsl:if test="not(translate($TitulIDREF,'abcdefghijklmnopqrstuvwxyz1234567890.ABCDEFGHIJKLMNOPQRSTUVWXYZ','')='')">
            <xsl:text>&#xD;&#xA;</xsl:text>
            <xsl:comment> .LOG&#xD;&#xA;ERROR: non-standard character(s) in title/IDREF (<xsl:value-of select="$TitulIDREF" />)&#xD;&#xA;.LOG </xsl:comment>
            <xsl:text>&#xD;&#xA;</xsl:text>
        </xsl:if>
        <xsl:if test="not(translate($TitulIDKEY/@xml:id,'abcdefghijklmnopqrstuvwxyz1234567890.ABCDEFGHIJKLMNOPQRSTUVWXYZ','')='')">
            <xsl:text>&#xD;&#xA;</xsl:text>
            <xsl:comment> .LOG&#xD;&#xA;ERROR: non-standard character(s) in title/ID (<xsl:value-of select="$TitulIDKEY/@xml:id" />)&#xD;&#xA;.LOG </xsl:comment>
            <xsl:text>&#xD;&#xA;</xsl:text>
        </xsl:if>
        <xsl:if test="not(translate($TitulIDKEY/n:Creacion/@xhtml:rel,'abcdefghijklmnopqrstuvwxyz1234567890.ABCDEFGHIJKLMNOPQRSTUVWXYZ','')='')">
            <xsl:text>&#xD;&#xA;</xsl:text>
            <xsl:comment> .LOG&#xD;&#xA;ERROR: non-standard character(s) in reign/IDREF/Cre (<xsl:value-of select="concat($TitulIDKEY/n:Creacion/@xhtml:rel,' @ ',$TitulIDREF)" />)&#xD;&#xA;.LOG </xsl:comment>
            <xsl:text>&#xD;&#xA;</xsl:text>
        </xsl:if>
        <xsl:if test="not(key('OrigenRdoID',$TitulIDKEY/n:Creacion/@xhtml:rel))">
            <xsl:text>&#xD;&#xA;</xsl:text>
            <xsl:comment> .LOG&#xD;&#xA;ERROR: use of non-defined reign/IDREF/Cre (<xsl:value-of select="concat($TitulIDKEY/n:Creacion/@xhtml:rel,' @ ',$TitulIDREF)" />)&#xD;&#xA;.LOG </xsl:comment>
            <xsl:text>&#xD;&#xA;</xsl:text>
        </xsl:if>
        <xsl:if test="$TitulIDKEY/n:Grandeza">
			<xsl:if test="not(translate($TitulIDKEY/n:Grandeza/@xhtml:rel,'abcdefghijklmnopqrstuvwxyz1234567890.ABCDEFGHIJKLMNOPQRSTUVWXYZ','')='')">
				<xsl:text>&#xD;&#xA;</xsl:text>
				<xsl:comment> .LOG&#xD;&#xA;ERROR: non-standard character(s) in reign/IDREF/GdE (<xsl:value-of select="concat($TitulIDKEY/n:Grandeza/@xhtml:rel,' @ ',$TitulIDREF)" />)&#xD;&#xA;.LOG </xsl:comment>
				<xsl:text>&#xD;&#xA;</xsl:text>
			</xsl:if>
			<xsl:if test="not(key('OrigenRdoID',$TitulIDKEY/n:Grandeza/@xhtml:rel))">
				<xsl:text>&#xD;&#xA;</xsl:text>
				<xsl:comment> .LOG&#xD;&#xA;ERROR: use of non-defined reign/IDREF/GdE (<xsl:value-of select="concat($TitulIDKEY/n:Grandeza/@xhtml:rel,' @ ',$TitulIDREF)" />)&#xD;&#xA;.LOG </xsl:comment>
				<xsl:text>&#xD;&#xA;</xsl:text>
			</xsl:if>
        </xsl:if>
        <xsl:if test="(../n:Nombre/n:Cortesia='Don' and $TitulMujer) or (../n:Nombre/n:Cortesia='Doa' and not($TitulMujer))">
            <xsl:text>&#xD;&#xA;</xsl:text>
            <xsl:comment> .LOG&#xD;&#xA;ERROR: non-matching courtesy vs gender of title's rank (<xsl:value-of select="$TitulIDREF" />)&#xD;&#xA;.LOG </xsl:comment>
            <xsl:text>&#xD;&#xA;</xsl:text>
        </xsl:if>
        <xsl:if test="count($TitulIDKEY)=1 and $NofSuccessions=1 and $NofMajorTitles=1">

        <xsl:text>&#xD;&#xA;</xsl:text>
        <item IDREFS="{$TitulIDREF}"> <!-- euser:uuid() -->
        <body>

        <n:Nobleza xml:id="{$TitulIDREF}">
            <xsl:attribute name="xhtml:class">
                <xsl:value-of select="@xhtml:class" />
                <xsl:choose>
                    <xsl:when test="$TitulIDKEY/n:Grandeza">
                        <xsl:value-of select="concat(' con',$TitulIDKEY/n:Grandeza/n:Instrumento[1]/@xhtml:classid)" />
                    </xsl:when>
                    <xsl:otherwise><xsl:text> sinGdE</xsl:text></xsl:otherwise>
                </xsl:choose>
				<xsl:if test="contains($SucesoGdEPC,concat('|',$TitulIDREF,'|'))"><xsl:call-template name="Suceso4ID"><xsl:with-param name="ID" select="$TitulIDREF" /></xsl:call-template></xsl:if>
                <!-- xsl:value-of select="concat(' N',format-number(count(../n:Sucesion),'00'))" / -->
            </xsl:attribute>
            <xsl:attribute name="xhtml:title">
                <xsl:value-of select="concat('N',format-number(count(../n:Sucesion),'00'))" />
            </xsl:attribute>
            <n:Sucesion>
                <xsl:copy-of select="./n:Instrumento[*]" />
            </n:Sucesion>
            <n:Titulo>
                <xsl:copy-of select="./n:Numero" />
                <n:Clase><xsl:value-of select="$TitulClase" /></n:Clase>
                <xsl:copy-of select="$TitulIDKEY/n:Parte" />
                <xsl:copy-of select="$TitulIDKEY/n:Denominacion" />
            </n:Titulo>
            <xsl:copy-of select="$TitulIDKEY/n:Creacion" />
            <xsl:copy-of select="$TitulIDKEY/n:Grandeza" />
            <n:Titular>
                <xsl:copy-of select="../n:Nombre" />
                <xsl:copy-of select="../n:Nacimiento" />
            </n:Titular>
            <xsl:if test="contains(@xhtml:class,'TMenor')">
                <xsl:variable name="TitulMayor" select="key('TitulXMLID',../n:Sucesion[contains(@xhtml:class,'TMayor')]/@xhtml:rel)" />
                <xsl:choose>
                    <xsl:when test="not($TitulMayor)">
                        <xsl:text>&#xD;&#xA;</xsl:text>
                        <xsl:comment> .LOG&#xD;&#xA;ERROR: minor-title/holder (<xsl:value-of select="$TitulIDREF" />) w/ non-existing major-title/IDREF&#xD;&#xA;.LOG </xsl:comment>
                        <xsl:text>&#xD;&#xA;</xsl:text>
                        <n:Nota><n:vease xlink:href="#NN.NN"><xsl:text>NN, NN de</xsl:text></n:vease></n:Nota>
                    </xsl:when>
                    <xsl:when test="count($TitulMayor)&gt;1">
                        <xsl:text>&#xD;&#xA;</xsl:text>
                        <xsl:comment> .LOG&#xD;&#xA;ERROR: minor-title/holder (<xsl:value-of select="$TitulIDREF" />) w/ non-unique major-title/IDREF&#xD;&#xA;.LOG </xsl:comment>
                        <xsl:text>&#xD;&#xA;</xsl:text>
                        <n:Nota><n:vease xlink:href="#NN.NN"><xsl:text>NN, NN de</xsl:text></n:vease></n:Nota>
                    </xsl:when>
                    <xsl:otherwise>
                        <n:Nota><n:vease xlink:href="#{$TitulMayor/@xml:id}"><xsl:value-of select="$TitulMayor/n:Denominacion" /><xsl:text>, </xsl:text><xsl:value-of select="$TitulMayor/n:Clase" /><xsl:text> </xsl:text><xsl:value-of select="$TitulMayor/n:Parte" /></n:vease></n:Nota>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>
        </n:Nobleza>

        </body>
        </item>
        <xsl:text>&#xD;&#xA;</xsl:text>

        </xsl:if>
    </xsl:for-each>


    <xsl:text>&#xD;&#xA;</xsl:text>
    <xsl:comment>  ================================================  </xsl:comment>
    <xsl:for-each select="//n:Titulo[(@xml:id!='') and not(key('SucesXLINK',@xml:id)) and not(child::n:Situacion)]">
            <xsl:text>&#xD;&#xA;</xsl:text>
            <xsl:comment> .LOG&#xD;&#xA;ERROR: title/ID (<xsl:value-of select="@xml:id" />) ignored for no successor nor situation&#xD;&#xA;.LOG </xsl:comment>
            <xsl:text>&#xD;&#xA;</xsl:text>
	</xsl:for-each>
    <xsl:comment>  ================================================  </xsl:comment>
    <xsl:text>&#xD;&#xA;</xsl:text>


    <xsl:for-each select="//n:Titulo[@xml:id!='']/n:Situacion">
        <xsl:sort select="number(concat(format-number(./n:Instrumento[last()]/adhoc:date/adhoc:y,'0000','nineY'),format-number(./n:Instrumento[last()]/adhoc:date/adhoc:m,'00','nineM'),format-number(./n:Instrumento[last()]/adhoc:date/adhoc:d,'00','nineD')))" data-type="number" order="ascending" />
        <xsl:if test="not(key('TitulXLINK',../@xml:id))">
        <xsl:if test="not(count(key('TitulXMLID',../@xml:id))=1)">
            <xsl:text>&#xD;&#xA;</xsl:text>
            <xsl:comment> .LOG&#xD;&#xA;ERROR: non-unique title/ID (<xsl:value-of select="../@xml:id" />)&#xD;&#xA;.LOG </xsl:comment>
            <xsl:text>&#xD;&#xA;</xsl:text>
        </xsl:if>
        <xsl:if test="not(translate(../@xml:id,'abcdefghijklmnopqrstuvwxyz1234567890.ABCDEFGHIJKLMNOPQRSTUVWXYZ','')='')">
            <xsl:text>&#xD;&#xA;</xsl:text>
            <xsl:comment> .LOG&#xD;&#xA;ERROR: non-standard character(s) in title/ID (<xsl:value-of select="../@xml:id" />)&#xD;&#xA;.LOG </xsl:comment>
            <xsl:text>&#xD;&#xA;</xsl:text>
        </xsl:if>
		<!--
        <xsl:if test="not(../@xml:id=translate(../@xml:id,'ܟ','yaeiouaeiouaeiouanoaeiouyYAEIOUAEIOUAEIOUANOAEIOUYcC'))">
            <xsl:text>&#xD;&#xA;</xsl:text>
            <xsl:comment> .LOG&#xD;&#xA;WARNING: accented character(s) in xml:id's ID (<xsl:value-of select="../@xml:id" />)&#xD;&#xA;.LOG </xsl:comment>
            <xsl:text>&#xD;&#xA;</xsl:text>
        </xsl:if>
		-->
        <xsl:if test="not(translate(../n:Creacion/@xhtml:rel,'abcdefghijklmnopqrstuvwxyz1234567890.ABCDEFGHIJKLMNOPQRSTUVWXYZ','')='')">
            <xsl:text>&#xD;&#xA;</xsl:text>
            <xsl:comment> .LOG&#xD;&#xA;ERROR: non-standard character(s) in reign/IDREF/Cre (<xsl:value-of select="concat(../n:Creacion/@xhtml:rel,' @ ',../@xml:id)" />)&#xD;&#xA;.LOG </xsl:comment>
            <xsl:text>&#xD;&#xA;</xsl:text>
        </xsl:if>
        <xsl:if test="not(key('OrigenRdoID',../n:Creacion/@xhtml:rel))">
            <xsl:text>&#xD;&#xA;</xsl:text>
            <xsl:comment> .LOG&#xD;&#xA;ERROR: use of non-defined reign/IDREF/Cre (<xsl:value-of select="concat(../n:Creacion/@xhtml:rel,' @ ',../@xml:id)" />)&#xD;&#xA;.LOG </xsl:comment>
            <xsl:text>&#xD;&#xA;</xsl:text>
        </xsl:if>
        <xsl:if test="../n:Grandeza">
			<xsl:if test="not(translate(../n:Grandeza/@xhtml:rel,'abcdefghijklmnopqrstuvwxyz1234567890.ABCDEFGHIJKLMNOPQRSTUVWXYZ','')='')">
				<xsl:text>&#xD;&#xA;</xsl:text>
				<xsl:comment> .LOG&#xD;&#xA;ERROR: non-standard character(s) in reign/IDREF/GdE (<xsl:value-of select="concat(../n:Grandeza/@xhtml:rel,' @ ',../@xml:id)" />)&#xD;&#xA;.LOG </xsl:comment>
				<xsl:text>&#xD;&#xA;</xsl:text>
			</xsl:if>
			<xsl:if test="not(key('OrigenRdoID',../n:Grandeza/@xhtml:rel))">
				<xsl:text>&#xD;&#xA;</xsl:text>
				<xsl:comment> .LOG&#xD;&#xA;ERROR: use of non-defined reign/IDREF/GdE (<xsl:value-of select="concat(../n:Grandeza/@xhtml:rel,' @ ',../@xml:id)" />)&#xD;&#xA;.LOG </xsl:comment>
				<xsl:text>&#xD;&#xA;</xsl:text>
			</xsl:if>
        </xsl:if>

        <xsl:text>&#xD;&#xA;</xsl:text>
        <item IDREFS="{../@xml:id}">
        <body>

        <n:Nobleza xml:id="{../@xml:id}">
            <xsl:attribute name="xhtml:class">
                <xsl:choose>
                    <xsl:when test="substring-before(../@xml:id,'.')='CondadoDucado'"><xsl:text>Condado Ducado</xsl:text></xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="substring-before(../@xml:id,'.')" />
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:value-of select="concat(' Titu',./n:Instrumento[last()]/@xhtml:classid)" />
                <xsl:choose>
                    <xsl:when test="../n:Grandeza">
                        <xsl:value-of select="concat(' con',../n:Grandeza/n:Instrumento[1]/@xhtml:classid)" />
                    </xsl:when>
                    <xsl:otherwise><xsl:text> sinGdE</xsl:text></xsl:otherwise>
                </xsl:choose>
				<xsl:if test="contains($SucesoGdEPC,concat('|',../@xml:id,'|'))"><xsl:call-template name="Suceso4ID"><xsl:with-param name="ID" select="../@xml:id" /></xsl:call-template></xsl:if>
				<!-- xsl:text> N00</xsl:text -->
            </xsl:attribute>
            <xsl:attribute name="xhtml:title"><xsl:text>N00</xsl:text></xsl:attribute>
            <n:Sucesion>
                <xsl:copy-of select="./n:Instrumento[last()]" />
            </n:Sucesion>
            <n:Titulo>
                <xsl:copy-of select="./n:Numero[last()]" />
                <xsl:copy-of select="../n:Clase" />
                <xsl:copy-of select="../n:Parte" />
                <xsl:copy-of select="../n:Denominacion" />
            </n:Titulo>
            <xsl:copy-of select="../n:Creacion" />
            <xsl:copy-of select="../n:Grandeza" />
            <n:Titular>
                <n:Nombre>
					<n:Cortesia/>
                    <n:dePila></n:dePila>
                    <n:Apellido></n:Apellido>
                </n:Nombre>
                <n:Nacimiento><date ISO="--"><y></y><m></m><d></d></date></n:Nacimiento>
            </n:Titular>
        </n:Nobleza>

        </body>
        </item>
        <xsl:text>&#xD;&#xA;</xsl:text>

        </xsl:if>
    </xsl:for-each>

    </list>

    <xsl:text>&#xD;&#xA;</xsl:text>
    <xsl:comment>  ================================================  </xsl:comment>
    <xsl:comment>  ================================================  </xsl:comment>
    <xsl:text>&#xD;&#xA;</xsl:text>

	<list>

	<!-- Reinado -->
    <xsl:for-each select="//n:Reinado">
        <xsl:text>&#xD;&#xA;</xsl:text>
        <item IDREFS="{@xml:id}">
        <body>
		<n:Reinado>
			<xsl:copy-of select="@*" />
            <xsl:if test="not(@xhtml:scope)"><xsl:attribute name="xhtml:scope"><xsl:text>NN</xsl:text></xsl:attribute></xsl:if>
            <xsl:if test="not(@xhtml:title)"><xsl:attribute name="xhtml:title"><xsl:text>N.N.</xsl:text></xsl:attribute></xsl:if>
            <xsl:attribute name="xhtml:value">
				<xsl:value-of select="concat('_',format-number(count(key('OrigenCreID',@xml:id)),'000'))" />			
				<xsl:value-of select="concat('_',format-number(count(key('SucesoCreID',@xml:id)),'000'))" />			
				<xsl:value-of select="concat('_',format-number(count(key('OrigenGdEID',@xml:id)),'000'))" />			
			</xsl:attribute>
			<xsl:for-each select="./n:Fecha">
				<xsl:copy-of select="self::node()" />
			</xsl:for-each>
		</n:Reinado>
        </body>
        </item>
        <xsl:text>&#xD;&#xA;</xsl:text>
	</xsl:for-each>
	<!-- Reinado -->
	
	</list>

    <xsl:text>&#xD;&#xA;</xsl:text>
    <xsl:comment>  ================================================  </xsl:comment>
    <xsl:comment>  ================================================  </xsl:comment>
    <xsl:text>&#xD;&#xA;</xsl:text>

    <hide>
        <data type="Instrumento" token="BO"     notation="B.O."     title="Boletn Oficial del Estado" />
        <data type="Instrumento" token="CC"     notation="C.C."     title="[a consulta de la] Cmara de Castilla" />
        <data type="Instrumento" token="CCa"    notation="C.Ca."    title="[a consulta de los] Cortes de Cdiz" />
        <data type="Instrumento" token="CConf"  notation="C.Conf."  title="Carta de Confirmacin" />
        <data type="Instrumento" token="CI"     notation="C.I."     title="[a consulta de la] Cmara de Indias" />
        <data type="Instrumento" token="CoR"    notation="Co.R."    title="Consejo de Regencia" />
        <data type="Instrumento" token="CP"     notation="C.P."     title="Carta Pontificia [Breve]" />
        <data type="Instrumento" token="CPS"    notation="C.P.S."   title="Carta Pontificia de Sucesin" />
        <data type="Instrumento" token="CR"     notation="C.R."     title="Carta de Rehabilitacin" />
        <data type="Instrumento" token="CS"     notation="C.S."     title="Carta de Sucesin" />
        <data type="Instrumento" token="C"      notation="C."       title="Carta" />
        <data type="Instrumento" token="D"      notation="D."       title="Decreto" />
        <data type="Instrumento" token="DespA"  notation="Desp.A."  title="Despacho de Autorizacin" />
        <data type="Instrumento" token="OA"     notation="O.A."     title="Orden de Autorizacin" />
        <data type="Instrumento" token="RA"     notation="R.A."     title="Real Autorizacin" />
        <data type="Instrumento" token="RC"     notation="R.C."     title="Real Cdula" />
        <data type="Instrumento" token="RCR"    notation="R.C.R."   title="Real Carta de Rehabilitacin" />
        <data type="Instrumento" token="RCS"    notation="R.C.S."   title="Real Carta de Sucesin" />
        <data type="Instrumento" token="RD"     notation="R.D."     title="Real Decreto" />
        <data type="Instrumento" token="RDR"    notation="R.D.R."   title="Real Decreto de Rehabilitacin" />
        <data type="Instrumento" token="RDesp"  notation="R.Desp."  title="Real Despacho" />
        <data type="Instrumento" token="RF"     notation="R.F."     title="Real Facultad" />
        <data type="Instrumento" token="RO"     notation="R.O."     title="Real Orden" />
        <data type="Instrumento" token="RP"     notation="R.P."     title="Real Privilegio" />
        <data type="Instrumento" token="SJ"     notation="S.J."     title="Sentencia judicial" />
				
        <data type="Instrumento" token="NN"     notation="N.N."     title="Nomen Nominandum" />
        <data type="Instrumento" token="desde"  notation="dsd."     title="[desde]" />
        <data type="Instrumento" token="hasta"  notation="hst."     title="[hasta]" />
        <data type="Instrumento" token="fecha"  notation="fha."     title="[fecha]" />
        <data type="Instrumento" token="dudoso" notation="dud."     title="caso/dato/tipo en duda (origen/ttulo/nombre/... dudoso)" />
        <data type="Instrumento" token="feudal" notation="fdl."     title="antiguo territorio/ttulo feudal" />
        <data type="Instrumento" token="legend" notation="leg."     title="caso/fecha de creacin legendaria" />

		<data type="Origen" token="TAra"    notation="T.Ara."       title="Ttulo de Aragn" />
		<data type="Origen" token="TAus"    notation="T.Aus."       title="Ttulo de Austria" />
		<data type="Origen" token="TBar"    notation="T.Bar."       title="Ttulo de Barcelona" />
		<data type="Origen" token="TCas"    notation="T.Cas."       title="Ttulo de Castilla" />
		<data type="Origen" token="TCer"    notation="T.Cer."       title="Ttulo de Cerdea" />
		<data type="Origen" token="TEsp"    notation="T.Esp."       title="Ttulo de Espaa" />
		<data type="Origen" token="TEspB"   notation="T.Esp.B."     title="Ttulo Bonapartista" />
		<data type="Origen" token="TEspC"   notation="T.Esp.C."     title="Ttulo Carlista" />
		<data type="Origen" token="TEspF"   notation="T.Esp.F."     title="Ttulo Franquista" />
		<data type="Origen" token="TEspGP"  notation="T.Esp.G.P."   title="Ttulo del Gobierno Provisional" />
		<data type="Origen" token="TEspI"   notation="T.Esp.Ind."   title="Ttulo de Indias (por los Reyes de Espaa)" />
		<data type="Origen" token="TEspIGP" notation="T.Esp.I.G.P." title="Ttulo de Indias (por el Gobierno Provisional)" />
		<data type="Origen" token="TEspP"   notation="T.Esp.P."     title="Ttulo del Archiduque Pretendiente Don Carlos de Austria" />
		<data type="Origen" token="Tfeud"   notation="T.feud."      title="Ttulo (del antiguo territorio) feudal" />
		<data type="Origen" token="TFla"    notation="T.Fla."       title="Ttulo de Flandes" />
		<data type="Origen" token="TFra"    notation="T.Fra."       title="Ttulo de Francia" />
		<data type="Origen" token="TInd"    notation="T.Ind."       title="Ttulo de Indias" />
		<data type="Origen" token="TIng"    notation="T.Ing."       title="Ttulo de Inglaterra" />
		<data type="Origen" token="TIta"    notation="T.Ita."       title="Ttulo de Italia" />
		<data type="Origen" token="TLuc"    notation="T.Luc."       title="Ttulo de Lucca" />
		<data type="Origen" token="TMal"    notation="T.Mal."       title="Ttulo de Mallorca" />
		<data type="Origen" token="TMco"    notation="T.Mco."       title="Ttulo de Mjico/Mxico" />
		<data type="Origen" token="TMil"    notation="T.Mil."       title="Ttulo de Miln" />
		<data type="Origen" token="TNap"    notation="T.Nap."       title="Ttulo de Npoles" />
		<data type="Origen" token="TNav"    notation="T.Nav."       title="Ttulo de Navarra" />
		<data type="Origen" token="TPor"    notation="T.Por."       title="Ttulo de Portugal" />
		<data type="Origen" token="TRC"     notation="T.R.C."       title="Ttulo de los Reyes Catlicos" />
		<data type="Origen" token="TRCI"    notation="T.R.C.Ind."   title="Ttulo de Indias (por los Reyes Catlicos)" />
		<data type="Origen" token="TDS"     notation="T.D.S."       title="Ttulo de las Dos Sicilias" />
		<data type="Origen" token="TSic"    notation="T.Sic."       title="Ttulo de Sicilia" />
		<data type="Origen" token="TSIR"    notation="T.S.I.R."     title="Ttulo del Sacro Imperio Romano" />
		<data type="Origen" token="TSM"     notation="T.S.M."       title="Ttulo de San Marino" />
		<data type="Origen" token="TSS"     notation="T.S.S."       title="Ttulo de la Santa Sede" />
		<data type="Origen" token="Tod"     notation="T.o.d."       title="Ttulo de origen desconocido" />

		<data type="Suceso" token="Sces"    notation="Suc.ces."    title="Caso/Suceso de cesin (Ttulo/Dignidad/Grandeza cedido/a)" />
		<data type="Suceso" token="Sinc"    notation="Suc.inc."    title="Caso/Suceso de incorporacin (Ttulo/Dignidad/Grandeza incorporado/a)" />
		<data type="Suceso" token="Srec"    notation="Suc.rec."    title="Caso/Suceso de reconocimiento (Ttulo/Dignidad/Grandeza reconocido/a)" />
        <data type="Suceso" token="Ssub"    notation="Suc.sub."    title="Caso/Suceso de subrogacin (Ttulo/Dignidad/Grandeza subrogado/a)" />
		<data type="Suceso" token="Stra"    notation="Suc.tra."    title="Caso/Suceso de transferencia (Ttulo/Dignidad/Grandeza transferido/a)" />

		<!-- Reinado -->
		<xsl:for-each select="//n:Reinado">
			<data type="Reinado" scope="{@xhtml:scope}" token="{@xml:id}" title="{@xhtml:title}" />
		</xsl:for-each>
		<!-- Reinado -->

        <data type="Grandeza" token="GdE"      notation="G.d.E."      		title="Grandeza de Espaa" />
        <data type="Grandeza" token="GdEPC"    notation="G.d.E.cre."  		title="Grandeza de Espaa de primera creacin [1 clase y antigedad]" />
        <data type="Grandeza" token="GdE1a"    notation="G.d.E.1"    		title="Grandeza de Espaa de primera clase" />
        <data type="Grandeza" token="GdE2a"    notation="G.d.E.2"    		title="Grandeza de Espaa de segunda clase" />
        <data type="Grandeza" token="GdE3a"    notation="G.d.E.3"    		title="Grandeza de Espaa de tercera clase" />
        <data type="Grandeza" token="GdEHon"   notation="G.d.E.hon."  		title="Grandeza de Espaa honoraria" />
        <data type="Grandeza" token="GdEVit"   notation="G.d.E.vit."  		title="Grandeza de Espaa vitalicia" />
        <data type="Grandeza" token="GdEPers"  notation="G.d.E.pers." 		title="Grandeza de Espaa personal" />
		<data type="Grandeza" token="cesGdEPC" notation="ces.G.d.E.ini."    title="G.za inicial (1.cre.) cedida" />
		<data type="Grandeza" token="incGdEPC" notation="inc.G.d.E.ini."    title="G.za inicial (1.cre.) incorporada" />
		<data type="Grandeza" token="recGdEPC" notation="rec.G.d.E.ini."    title="G.za inicial (1.cre.) reconocida" />
        <data type="Grandeza" token="subGdEPC" notation="sub.G.d.E.ini."    title="G.za inicial (1.cre.) subrogada" />
		<data type="Grandeza" token="traGdEPC" notation="tra.G.d.E.ini."    title="G.za inicial (1.cre.) transferida" />

        <data type="Situacion" token="Ele" notation="ele." title="Caso/Fecha de eleccin, Ttulo electo" />
        <data type="Situacion" token="Cre" notation="cre." title="Caso/Fecha de creacin" />
        <data type="Situacion" token="Acc" notation="acc." title="Caso/Fecha de accesin" />
        <data type="Situacion" token="Suc" notation="suc." title="Caso/Fecha de sucesin" />
        <data type="Situacion" token="Ces" notation="ces." title="Caso/Fecha de cesin, Ttulo/Dignidad/Grandeza cedido/a" />
        <data type="Situacion" token="Inc" notation="inc." title="Caso/Fecha de incorporacin, Ttulo/Dignidad/Grandeza incorporado/a" />
        <data type="Situacion" token="Rec" notation="rec." title="Caso/Fecha de reconocimiento, Ttulo/Dignidad/Grandeza reconocido/a" />
        <data type="Situacion" token="Sub" notation="sub." title="Caso/Fecha de subrogacin, Ttulo/Dignidad/Grandeza subrogado/a" />
        <data type="Situacion" token="Tra" notation="tra." title="Caso/Fecha de transferencia, Ttulo/Dignidad/Grandeza transferido/a" />
        <data type="Situacion" token="Ocu" notation="ocu." title="Caso/Fecha de ocupacin [= acc./suc.], Ttulo ocupado/vigente" />
        <data type="Situacion" token="Vac" notation="vac." title="Caso/Fecha de vacancia, Ttulo vacante [desde que da de la muerte de titular precedente]" />
        <data type="Situacion" token="Can" notation="can." title="Caso/Fecha de cancelacin, Ttulo cancelado" />
        <data type="Situacion" token="Ren" notation="ren." title="Caso/Fecha de renunciacin, Ttulo renunciado" />
        <data type="Situacion" token="Anu" notation="anu." title="Caso/Fecha de anulacin, Ttulo anulado" />
        <data type="Situacion" token="Cad" notation="cad." title="Caso/Fecha de caducidad, Ttulo caducado" />
        <data type="Situacion" token="Sup" notation="sup." title="Caso/Fecha de supresin, Ttulo suprimido" />
        <data type="Situacion" token="Rev" notation="rev." title="Caso/Fecha de reversin, Ttulo revertido" />
        <data type="Situacion" token="Ext" notation="ext." title="Caso/Fecha de extincin, Ttulo extinguido" />
        <data type="Situacion" token="Sus" notation="sus." title="Caso/Fecha de suspensin, Ttulo suspenso" />

        <data type="Clase" token="CondadoDucado" tone="Conde Duque"      title="Conde-Duque" />
        <data type="Clase" token="CondadoDucado" tone="Condesa Duquesa"  title="Condesa-Duquesa" />
        <data type="Clase" token="CondadoDucado" tone="Condado Ducado"   title="Condado-Ducado" />
        <data type="Clase" token="Principado"    tone="Principe"         title="Prncipe" />
        <data type="Clase" token="Principado"    tone="Princesa"         title="Princesa" />
        <data type="Clase" token="Principado"    tone="Principado"       title="Principado" />
        <data type="Clase" token="Ducado"        tone="Duque"            title="Duque" />
        <data type="Clase" token="Ducado"        tone="Duquesa"          title="Duquesa" />
        <data type="Clase" token="Ducado"        tone="Ducado"           title="Ducado" />
        <data type="Clase" token="Marquesado"    tone="Marques"          title="Marqus" />
        <data type="Clase" token="Marquesado"    tone="Marquesa"         title="Marquesa" />
        <data type="Clase" token="Marquesado"    tone="Marquesado"       title="Marquesado" />
        <data type="Clase" token="Condado"       tone="Conde"            title="Conde" />
        <data type="Clase" token="Condado"       tone="Condesa"          title="Condesa" />
        <data type="Clase" token="Condado"       tone="Condado"          title="Condado" />
        <data type="Clase" token="Vizcondado"    tone="Vizconde"         title="Vizconde" />
        <data type="Clase" token="Vizcondado"    tone="Vizcondesa"       title="Vizcondesa" />
        <data type="Clase" token="Vizcondado"    tone="Vizcondado"       title="Vizcondado" />
        <data type="Clase" token="Baronia"       tone="Baron"            title="Barn" />
        <data type="Clase" token="Baronia"       tone="Baronesa"         title="Baronesa" />
        <data type="Clase" token="Baronia"       tone="Baronia"          title="Barona" />
        <data type="Clase" token="Senorio"       tone="Senor"            title="Seor" />
        <data type="Clase" token="Senorio"       tone="Senora"           title="Seora" />
        <data type="Clase" token="Senorio"       tone="Senorio"          title="Seoro" />
        <data type="Clase" token="Grandeza"      tone="Grande"           title="Dignidad" />
        <data type="Clase" token="Grandeza"      tone="Grandesa"         title="Dignidad" />
        <data type="Clase" token="Grandeza"      tone="Grandeza"         title="Dignidad" />
        <data type="Clase" token="Infantazgo"    tone="Infante"          title="Dignidad" />
        <data type="Clase" token="Infantazgo"    tone="Infanta"          title="Dignidad" />
        <data type="Clase" token="Infantazgo"    tone="Infantazgo"       title="Dignidad" />
        <data type="Clase" token="Mariscalato"   tone="Mariscal"         title="Mariscal" />
        <data type="Clase" token="Mariscalato"   tone="Mariscala"        title="Mariscala" />
        <data type="Clase" token="Mariscalato"   tone="Mariscalato"      title="Mariscalato" />
        <data type="Clase" token="Almirantazgo"  tone="Almirante"        title="Almirante" />
        <data type="Clase" token="Almirantazgo"  tone="Almiranta"        title="Almiranta" />
        <data type="Clase" token="Almirantazgo"  tone="Almirantazgo"     title="Almirantazgo" />
        <data type="Clase" token="Adelantamiento"   tone="Adelantado"       title="Adelantado Mayor" />
        <data type="Clase" token="Adelantamiento"   tone="Adelantada"       title="Adelantada Mayor" />
        <data type="Clase" token="Adelantamiento"   tone="Adelantamiento"   title="Adelantamiento Mayor" />
    </hide>

    <xsl:text>&#xD;&#xA;</xsl:text>
    <xsl:comment>  ================================================  </xsl:comment>
    <xsl:comment>  ================================================  </xsl:comment>
    </n:NobiliarioEspanol>
    </AdHocDoc>
</xsl:template>

<xsl:template name="Class2Clase"> <!--  translate( ,'-ܟ','yaeiouaeiouaeiouanoaeiouy YAEIOUAEIOUAEIOUANOAEIOUYcC')  -->
    <xsl:param name="C2C" />
    <xsl:choose>
        <xsl:when test="contains($C2C,'Conde Duque')"><xsl:text>Conde-Duque</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Condesa Duquesa')"><xsl:text>Condesa-Duquesa</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Condado Ducado')"><xsl:text>Condado-Ducado</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Principe')"><xsl:text>Prncipe</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Princesa')"><xsl:text>Princesa</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Principado')"><xsl:text>Principado</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Duque ')"><xsl:text>Duque</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Duquesa')"><xsl:text>Duquesa</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Ducado')"><xsl:text>Ducado</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Marques ')"><xsl:text>Marqus</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Marquesa ')"><xsl:text>Marquesa</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Marquesado')"><xsl:text>Marquesado</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Conde ')"><xsl:text>Conde</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Condesa')"><xsl:text>Condesa</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Condado')"><xsl:text>Condado</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Vizconde ')"><xsl:text>Vizconde</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Vizcondesa')"><xsl:text>Vizcondesa</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Vizcondado')"><xsl:text>Vizcondado</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Baron ')"><xsl:text>Barn</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Baronesa')"><xsl:text>Baronesa</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Baronia')"><xsl:text>Barona</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Senor ')"><xsl:text>Seor</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Senora')"><xsl:text>Seora</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Senorio')"><xsl:text>Seoro</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Grande ')"><xsl:text>Dignidad</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Grandesa')"><xsl:text>Dignidad</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Grandeza')"><xsl:text>Dignidad</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Infante ')"><xsl:text>Dignidad</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Infanta ')"><xsl:text>Dignidad</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Infantazgo')"><xsl:text>Dignidad</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Mariscal ')"><xsl:text>Mariscal</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Mariscala ')"><xsl:text>Mariscala</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Mariscalato')"><xsl:text>Mariscalato</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Almirante')"><xsl:text>Almirante</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Almiranta ')"><xsl:text>Almiranta</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Almirantazgo')"><xsl:text>Almirantazgo</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Adelantado')"><xsl:text>Adelantado Mayor</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Adelantada')"><xsl:text>Adelantada Mayor</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Adelantamiento')"><xsl:text>Adelantamiento Mayor</xsl:text></xsl:when>
        <xsl:otherwise>
            <xsl:text>NN</xsl:text>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template name="Class2Class">
    <xsl:param name="C2C" />
    <xsl:choose>
        <xsl:when test="contains($C2C,'Ele')"><xsl:text>TituEle</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Ocu')"><xsl:text>TituOcu</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Vac')"><xsl:text>TituVac</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Can')"><xsl:text>TituCan</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Anu')"><xsl:text>TituAnu</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Cad')"><xsl:text>TituCad</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Sup')"><xsl:text>TituSup</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Rev')"><xsl:text>TituRev</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Ren')"><xsl:text>TituRen</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Ext')"><xsl:text>TituExt</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Ces')"><xsl:text>CasoCes</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Inc')"><xsl:text>CasoInc</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Rec')"><xsl:text>CasoRec</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Sub')"><xsl:text>CasoSub</xsl:text></xsl:when>
        <xsl:when test="contains($C2C,'Tra')"><xsl:text>CasoTra</xsl:text></xsl:when>
        <xsl:otherwise>
            <xsl:text>TituNN</xsl:text>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template name="Suceso4ID">
    <xsl:param name="ID" />
    <xsl:choose>
        <xsl:when test="$ID='Ducado.Lerma'"><xsl:text> subGdEPC</xsl:text></xsl:when>
        <xsl:when test="$ID='Ducado.MedinaRioseco'"><xsl:text> subGdEPC</xsl:text></xsl:when>
        <xsl:when test="$ID='Ducado.PenarandaDuero'"><xsl:text> subGdEPC</xsl:text></xsl:when>
        <xsl:when test="$ID='Ducado.Osuna'"><xsl:text> subGdEPC</xsl:text></xsl:when>
        <xsl:when test="$ID='Ducado.Infantado'"><xsl:text> incGdEPC</xsl:text></xsl:when>
        <xsl:when test="$ID='Marquesado.Santillana'"><xsl:text> recGdEPC</xsl:text></xsl:when>
        <xsl:when test="$ID='Marquesado.Cenete'"><xsl:text> traGdEPC</xsl:text></xsl:when>
        <xsl:when test="$ID='Marquesado.Denia2'"><xsl:text> cesGdEPC</xsl:text></xsl:when>
        <xsl:when test="$ID='Condado.Melgar'"><xsl:text> cesGdEPC</xsl:text></xsl:when>
        <xsl:when test="$ID='Condado.MirandaCastanar'"><xsl:text> cesGdEPC</xsl:text></xsl:when>
        <xsl:when test="$ID='Condado.Urena2'"><xsl:text> cesGdEPC</xsl:text></xsl:when>
    </xsl:choose>
</xsl:template>

<!--  ================================================  -->
<!--  ================================================  -->
<!--  ================================================  -->

<xsl:template name="splitTT">

    <xsl:comment>  ================================================  </xsl:comment>
    <xsl:comment>  ================================================

      Copyright (c) <xsl:value-of select="substring-before($MakeDate,'-')" /> ff. O.Rost  [Creation 2006-Mar-04]  cf. Nobiliario.rdf

      Project ID: NobiliarioEspanol
      Generic URI: http://www.unterstein.net/NobiliarioEspanol
      License: Creative Commons Attribution-NonCommercial-ShareAlike License [by-nc-sa]
      License URI: http://creativecommons.org/licenses/by-nc-sa/4.0/

      Description:

      Nobiliario de todos los titulares con instrumento y fecha de sucesin
               y de todos los ttulos espaoles con instrumento y fecha de creacin, etc.

      ================================================  </xsl:comment>
    <xsl:comment>  ================================================  </xsl:comment>

    <AdHocXML xmlns="urn:xmlns:adhoc">
    <meta xlink:title="Creative Commons License + Dublin Core Metadata" xlink:type="resource" xlink:show="embed" xlink:actuate="onLoad" xlink:href="Nobiliario.rdf" />

    <xsl:comment>  ================================================  </xsl:comment>
    <xsl:comment>  ================================================  </xsl:comment>
    <xsl:comment>  &lt;n:Titulares&gt; ==================================  </xsl:comment>
    <xsl:text>&#xD;&#xA;</xsl:text>

    <xsl:for-each select="//adhoc:list[1]/adhoc:item[contains(./adhoc:body/n:Nobleza/@xhtml:class,'TMayor')]">
        <xsl:text>&#xD;&#xA;</xsl:text>
        <n:Titular>
            <xsl:copy-of select="./adhoc:body/n:Nobleza/n:Titular/n:Nombre" />
            <xsl:copy-of select="./adhoc:body/n:Nobleza/n:Titular/n:Nacimiento" />
            <xsl:comment>  TTULO(S)  </xsl:comment>
            <xsl:for-each select="key('NobilXMLID',./adhoc:body/n:Nobleza/@xml:id) | key('NobilXLINK',./adhoc:body/n:Nobleza/@xml:id)">
                <n:Sucesion xhtml:rel="{./adhoc:body/n:Nobleza/@xml:id}" xhtml:class="{./adhoc:body/n:Nobleza/@xhtml:class}">
                    <xsl:copy-of select="./adhoc:body/n:Nobleza/n:Titulo/n:Numero" />
                    <xsl:copy-of select="./adhoc:body/n:Nobleza/n:Sucesion/n:Instrumento[*]" />
                </n:Sucesion>
            </xsl:for-each>
        </n:Titular>
        <xsl:text>&#xD;&#xA;</xsl:text>
    </xsl:for-each>

    <xsl:text>&#xD;&#xA;</xsl:text>
    <xsl:comment>  &lt;/n:Titulares&gt; =================================  </xsl:comment>
    <xsl:comment>  ================================================  </xsl:comment>
    <xsl:comment>  ================================================  </xsl:comment>
    <xsl:comment>  &lt;n:Titulos&gt; ====================================  </xsl:comment>
    <xsl:text>&#xD;&#xA;</xsl:text>

    <xsl:for-each select="//adhoc:list[1]/adhoc:item">
        <xsl:sort select="substring-after(./adhoc:body/n:Nobleza/@xml:id,'.')" lang="es" data-type="text" />
        <xsl:text>&#xD;&#xA;</xsl:text>
        <n:Titulo xml:id="{./adhoc:body/n:Nobleza/@xml:id}">
            <n:Clase>
                <xsl:call-template name="Id2Clase">
                    <xsl:with-param name="I2C" select="substring-before(./adhoc:body/n:Nobleza/@xml:id,'.')" />
                </xsl:call-template>
            </n:Clase>
            <xsl:copy-of select="./adhoc:body/n:Nobleza/n:Titulo/n:Parte" />
            <xsl:copy-of select="./adhoc:body/n:Nobleza/n:Titulo/n:Denominacion" />
            <xsl:copy-of select="./adhoc:body/n:Nobleza/n:Creacion" />
            <xsl:copy-of select="./adhoc:body/n:Nobleza/n:Grandeza" />
        </n:Titulo>
        <xsl:text>&#xD;&#xA;</xsl:text>
    </xsl:for-each>

    <xsl:text>&#xD;&#xA;</xsl:text>
    <xsl:comment>  &lt;/n:Titulos&gt; ===================================  </xsl:comment>
    <xsl:comment>  ================================================  </xsl:comment>
    <xsl:comment>  ================================================  </xsl:comment>

    </AdHocXML>
</xsl:template>

<xsl:template name="Id2Clase">
    <xsl:param name="I2C" />
    <xsl:choose>
        <xsl:when test="$I2C='CondadoDucado'">
            <xsl:text>Condado-Ducado</xsl:text>
        </xsl:when>
        <xsl:when test="$I2C='Baronia'">
            <xsl:text>Barona</xsl:text>
        </xsl:when>
        <xsl:when test="$I2C='Senorio'">
            <xsl:text>Seoro</xsl:text>
        </xsl:when>
        <xsl:when test="$I2C='Grandeza'">
            <xsl:text>Dignidad</xsl:text>
        </xsl:when>
        <xsl:when test="$I2C='Infantazgo'">
            <xsl:text>Dignidad</xsl:text>
        </xsl:when>
        <xsl:when test="$I2C='Adelantamiento'">
            <xsl:text>Adelantamiento Mayor</xsl:text>
        </xsl:when>
        <xsl:otherwise>
            <xsl:value-of select="$I2C" />
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template name="Class2IdPfx">
    <xsl:param name="C2I" />
    <xsl:choose>
        <xsl:when test="contains($C2I,'Conde Duque') or contains($C2I,'Condesa Duquesa')">
            <xsl:text>CondadoDucado</xsl:text>
        </xsl:when>
        <xsl:when test="contains($C2I,'Principe') or contains($C2I,'Princesa')">
            <xsl:text>Principado</xsl:text>
        </xsl:when>
        <xsl:when test="contains($C2I,'Duque') or contains($C2I,'Duquesa')">
            <xsl:text>Ducado</xsl:text>
        </xsl:when>
        <xsl:when test="contains($C2I,'Marques') or contains($C2I,'Marquesa')">
            <xsl:text>Marquesado</xsl:text>
        </xsl:when>
        <xsl:when test="contains($C2I,'Conde') or contains($C2I,'Condesa')">
            <xsl:text>Condado</xsl:text>
        </xsl:when>
        <xsl:when test="contains($C2I,'Vizconde') or contains($C2I,'Vizcondesa')">
            <xsl:text>Vizcondado</xsl:text>
        </xsl:when>
        <xsl:when test="contains($C2I,'Baron') or contains($C2I,'Baronesa')">
            <xsl:text>Baronia</xsl:text>
        </xsl:when>
        <xsl:when test="contains($C2I,'Senor') or contains($C2I,'Senora')">
            <xsl:text>Senorio</xsl:text>
        </xsl:when>
        <xsl:when test="contains($C2I,'Grande') or contains($C2I,'Grandesa')">
            <xsl:text>Grandeza</xsl:text>
        </xsl:when>
        <xsl:when test="contains($C2I,'Infante') or contains($C2I,'Infanta')">
            <xsl:text>Infantazgo</xsl:text>
        </xsl:when>
        <xsl:when test="contains($C2I,'Mariscal') or contains($C2I,'Mariscala')">
            <xsl:text>Mariscalato</xsl:text>
        </xsl:when>
        <xsl:when test="contains($C2I,'Almirante') or contains($C2I,'Almiranta')">
            <xsl:text>Almirantazgo</xsl:text>
        </xsl:when>
        <xsl:when test="contains($C2I,'Adelantado') or contains($C2I,'Adelantada')">
            <xsl:text>Adelantamiento</xsl:text>
        </xsl:when>
        <xsl:otherwise>
            <xsl:text>NN</xsl:text>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<!--  ================================================  -->
<!--  ================================================  -->
<!--  ================================================  -->

<xsl:template name="deepcopy">
    <xsl:copy-of select="@*|node()" />
</xsl:template>
<xsl:template name="flatcopy">
    <xsl:copy><xsl:apply-templates select="@*|node()" /></xsl:copy>
</xsl:template>

<!--  ================================================  -->
<!--  ================================================  -->
<!--  ================================================  -->

<xsl:template name="statsTT">

    <xsl:variable name="NumTitulos"   select="count(//n:Titulo)" />
    <xsl:variable name="NumTitulares" select="count(//n:Titular)" />
    <xsl:variable name="NumSucesion"  select="count(//n:Titular/n:Sucesion)" />
    <xsl:variable name="NumGrandeza"  select="count(//n:Titulo/n:Grandeza)" />
    <xsl:variable name="NumTitulosMayor"  select="count(//n:Titular/n:Sucesion[contains(@xhtml:class,'TMayor')])" />
    <xsl:variable name="NumTitulosMenor"  select="count(//n:Titular/n:Sucesion[contains(@xhtml:class,'TMenor')])" />
    <xsl:variable name="NumTitulosOtros"  select="number($NumTitulos)-number($NumSucesion)" />
    <xsl:variable name="NumMujeresMenor"  select="count(//n:Titular/n:Sucesion[contains(@xhtml:class,'a TMenor')])" />
    <xsl:variable name="NumMujeresSuces"  select="count(//n:Titular/n:Sucesion[contains(@xhtml:class,'a TM')])" />
    <xsl:variable name="NumMujeres"  select="count(//n:Titular/n:Sucesion[contains(@xhtml:class,'a TMayor')])" />
    <xsl:variable name="NumVaronesMenor"  select="number($NumTitulosMenor)-number($NumMujeresMenor)" />
    <xsl:variable name="NumVaronesSuces"  select="number($NumSucesion)-number($NumMujeresSuces)" />
    <xsl:variable name="NumVarones"  select="number($NumTitulares)-number($NumMujeres)" />

    <xsl:value-of select="concat('                                      M :    F :    X','&#xD;&#xA;')" />
    <xsl:value-of select="concat('      Ttulos:             ',$NumTitulos,'    ',$NumVaronesSuces,' :  ',$NumMujeresSuces,' : ',format-number($NumTitulosOtros,'0000'),'&#xD;&#xA;')" />
    <xsl:value-of select="concat('      Ttulos ocupados:    ',$NumSucesion,'    ',$NumVaronesSuces,' :  ',$NumMujeresSuces,' :    -&#xD;&#xA;')" />
    <xsl:value-of select="concat('      Ttulos principales: ',$NumTitulosMayor,'    ',$NumVarones,' :  ',$NumMujeres,' :   (= Titulares)&#xD;&#xA;')" />
    <xsl:value-of select="concat('      Ttulos vinculados:   ',$NumTitulosMenor,'     ',$NumVaronesMenor,' :  ',format-number($NumMujeresMenor,'000'),' :    -&#xD;&#xA;')" />
    <xsl:value-of select="concat('      - Principados:          ',count(key('TitulCLSID','Principado')),'       ',count(key('SucesCLASS','Principe')),' :    ',count(key('SucesCLASS','Princesa')),' :    ?&#xD;&#xA;')" />
    <xsl:value-of select="concat('      - Ducados:            ',count(key('TitulCLSID','Ducado')),'     ',count(key('SucesCLASS','Duque')),' :   ',count(key('SucesCLASS','Duquesa')),' :    ?&#xD;&#xA;')" />
    <xsl:value-of select="concat('      - Condados-Ducados:     ',count(key('TitulCLSID','CondadoDucado')),'       ',count(key('SucesCLASS','Conde Duque')),' :    ',count(key('SucesCLASS','Condesa Duquesa')),' :    ?&#xD;&#xA;')" />
    <xsl:value-of select="concat('      - Marquesados:       ',count(key('TitulCLSID','Marquesado')),'     ',count(key('SucesCLASS','Marques')),' :  ',count(key('SucesCLASS','Marquesa')),' :    ?&#xD;&#xA;')" />
    <xsl:value-of select="concat('      - Condados:          ',count(key('TitulCLSID','Condado')),'     ',count(key('SucesCLASS','Conde')),' :  ',count(key('SucesCLASS','Condesa')),' :    ?&#xD;&#xA;')" />
    <xsl:value-of select="concat('      - Vizcondados:        ',count(key('TitulCLSID','Vizcondado')),'     ',format-number(count(key('SucesCLASS','Vizconde')),'000'),' :   ',count(key('SucesCLASS','Vizcondesa')),' :    ?&#xD;&#xA;')" />
    <xsl:value-of select="concat('      - Baronas:           ',count(key('TitulCLSID','Baronia')),'     ',count(key('SucesCLASS','Baron')),' :   ',count(key('SucesCLASS','Baronesa')),' :    ?&#xD;&#xA;')" />
    <xsl:value-of select="concat('      - Seoros:             ',count(key('TitulCLSID','Senorio')),'       ',count(key('SucesCLASS','Senor')),' :    ',count(key('SucesCLASS','Senora')),' :    ?&#xD;&#xA;')" />
    <xsl:value-of select="concat('      - Grandezas sin ttulo: ',count(key('TitulCLSID','Grandeza')),'       ',count(key('SucesCLASS','Grande')),' :    ',count(key('SucesCLASS','Grandesa')),' :    ?&#xD;&#xA;')" />
    <xsl:value-of select="concat('      - Mariscalatos:         ',count(key('TitulCLSID','Mariscalato')),'       ',count(key('SucesCLASS','Mariscal')),' :    ',count(key('SucesCLASS','Mariscala')),' :    ?&#xD;&#xA;')" />
    <xsl:value-of select="concat('      - Almirantazgos:        ',count(key('TitulCLSID','Almirantazgo')),'       ',count(key('SucesCLASS','Almirante')),' :    ',count(key('SucesCLASS','Almiranta')),' :    ?&#xD;&#xA;')" />
    <xsl:value-of select="concat('      - Adelantamientos:      ',count(key('TitulCLSID','Adelantamiento')),'       ',count(key('SucesCLASS','Adelantado')),' :    ',count(key('SucesCLASS','Adelantada')),' :    ?&#xD;&#xA;')" />
    <xsl:value-of select="concat('      Grandezas de Espaa:  ',$NumGrandeza,'       ? :    ? :    ?&#xD;&#xA;')" />
	<!--
    <xsl:value-of select="concat('      Titulares:           ',$NumTitulares,'    ',$NumVarones,' :  ',$NumMujeres,' :    -&#xD;&#xA;')" />
      -->
</xsl:template>

<!--  ================================================  -->
<!--  ================================================  -->
<!--  ================================================  -->

</xsl:stylesheet>

<!--  ================================================  -->
<!--  EOF                                               -->
<!--  ================================================  -->